/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.impl.configuration.RemoteServerState;
import com.intellij.remoteServer.impl.configuration.RemoteServersManagerState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteServers", storages={@Storage(value="remote-servers.xml")})
public class RemoteServersManagerImpl
extends RemoteServersManager
implements PersistentStateComponent<RemoteServersManagerState> {
    public static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private List<RemoteServer<?>> myServers = new ArrayList();
    private List<RemoteServerState> myUnknownServers = new ArrayList<RemoteServerState>();
    private final MessageBus myMessageBus;

    public RemoteServersManagerImpl(MessageBus messageBus) {
        this.myMessageBus = messageBus;
    }

    public List<RemoteServer<?>> getServers() {
        return Collections.unmodifiableList(this.myServers);
    }

    public <C extends ServerConfiguration> List<RemoteServer<C>> getServers(@NotNull ServerType<C> type) {
        ArrayList<RemoteServer<C>> servers = new ArrayList<RemoteServer<C>>();
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type)) continue;
            servers.add(server);
        }
        return servers;
    }

    @Nullable
    public <C extends ServerConfiguration> RemoteServer<C> findByName(@NotNull String name, @NotNull ServerType<C> type) {
        for (RemoteServer<?> server : this.myServers) {
            if (!server.getType().equals(type) || !server.getName().equals(name)) continue;
            return server;
        }
        return null;
    }

    public <C extends ServerConfiguration> RemoteServer<C> createServer(@NotNull ServerType<C> type, @NotNull String name) {
        return new RemoteServerImpl<ServerConfiguration>(name, type, type.createDefaultConfiguration());
    }

    public void addServer(RemoteServer<?> server) {
        this.myServers.add(server);
        ((RemoteServerListener)this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC)).serverAdded(server);
    }

    public void removeServer(RemoteServer<?> server) {
        this.myServers.remove(server);
        ((RemoteServerListener)this.myMessageBus.syncPublisher(RemoteServerListener.TOPIC)).serverRemoved(server);
    }

    @Nullable
    public RemoteServersManagerState getState() {
        RemoteServersManagerState state = new RemoteServersManagerState();
        for (RemoteServer<?> server : this.myServers) {
            RemoteServerState serverState = new RemoteServerState();
            serverState.myName = server.getName();
            serverState.myTypeId = server.getType().getId();
            serverState.myConfiguration = XmlSerializer.serialize((Object)server.getConfiguration().getSerializer().getState(), (SerializationFilter)SERIALIZATION_FILTERS);
            state.myServers.add(serverState);
        }
        state.myServers.addAll(this.myUnknownServers);
        return state;
    }

    public void loadState(RemoteServersManagerState state) {
        this.myUnknownServers.clear();
        this.myServers.clear();
        for (RemoteServerState server : state.myServers) {
            ServerType<?> type = RemoteServersManagerImpl.findServerType(server.myTypeId);
            if (type == null) {
                this.myUnknownServers.add(server);
                continue;
            }
            this.myServers.add(RemoteServersManagerImpl.createConfiguration(type, server));
        }
    }

    private static <C extends ServerConfiguration> RemoteServerImpl<C> createConfiguration(ServerType<C> type, RemoteServerState server) {
        ServerConfiguration configuration = type.createDefaultConfiguration();
        PersistentStateComponent serializer = configuration.getSerializer();
        ComponentSerializationUtil.loadComponentState(serializer, server.myConfiguration);
        return new RemoteServerImpl<ServerConfiguration>(server.myName, type, configuration);
    }

    @Nullable
    private static ServerType<?> findServerType(@NotNull String typeId) {
        for (ServerType serverType : (ServerType[])ServerType.EP_NAME.getExtensions()) {
            if (!serverType.getId().equals(typeId)) continue;
            return serverType;
        }
        return null;
    }
}

