/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentCredentialsHolder {
    public static final String WEB_SERVER_CONFIG_ID = "WEB_SERVER_CONFIG_ID";
    public static final String WEB_SERVER_CONFIG_NAME = "WEB_SERVER_CONFIG_NAME";
    private String myWebServerConfigId;
    private final RemoteCredentialsHolder myRemoteCredentials = new RemoteCredentialsHolder();
    private String myWebServerConfigName;

    public WebDeploymentCredentialsHolder() {
    }

    public WebDeploymentCredentialsHolder(@NotNull String webServerConfigId, String name, @NotNull RemoteCredentials remoteCredentials) {
        this.myWebServerConfigId = webServerConfigId;
        this.myWebServerConfigName = name;
        this.myRemoteCredentials.copyFrom(remoteCredentials);
    }

    @Nullable
    public String getWebServerConfigId() {
        return this.myWebServerConfigId;
    }

    public void setWebServerConfigId(@NotNull String webServerConfigId) {
        this.myWebServerConfigId = webServerConfigId;
    }

    public String getWebServerConfigName() {
        return this.myWebServerConfigName;
    }

    public void setWebServerConfigName(@NotNull String name) {
        this.myWebServerConfigName = name;
    }

    public void load(Element element) {
        this.myRemoteCredentials.load(element);
        this.setWebServerConfigId(element.getAttributeValue(WEB_SERVER_CONFIG_ID));
        this.setWebServerConfigName(StringUtil.notNullize((String)element.getAttributeValue(WEB_SERVER_CONFIG_NAME)));
    }

    public void save(Element element) {
        element.setAttribute(WEB_SERVER_CONFIG_ID, this.getWebServerConfigId());
        element.setAttribute(WEB_SERVER_CONFIG_NAME, this.getWebServerConfigName());
        this.myRemoteCredentials.save(element);
    }

    public RemoteCredentials getSshCredentials() {
        return this.myRemoteCredentials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeploymentCredentialsHolder holder = (WebDeploymentCredentialsHolder)o;
        return this.myWebServerConfigId.equals(holder.myWebServerConfigId);
    }

    public int hashCode() {
        return this.myWebServerConfigId.hashCode();
    }
}

