/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import org.jetbrains.annotations.NotNull;

public class RemoteFile {
    private final boolean myWin;
    private final String myPath;

    public RemoteFile(@NotNull String path, boolean isWin) {
        this.myPath = RemoteFile.toSystemDependent(path, isWin);
        this.myWin = isWin;
    }

    public RemoteFile(@NotNull String parent, String child) {
        this(RemoteFile.resolveChild(parent, child, RemoteFile.isWindowsPath(parent)), RemoteFile.isWindowsPath(parent));
    }

    public RemoteFile(@NotNull String parent, String child, boolean isWin) {
        this(RemoteFile.resolveChild(parent, child, isWin), isWin);
    }

    @NotNull
    public String getName() {
        int ind = this.myPath.lastIndexOf(RemoteFile.getSeparator(this.myWin));
        if (ind != -1 && ind < this.myPath.length() - 1) {
            return this.myPath.substring(ind + 1);
        }
        return this.myPath;
    }

    private static String resolveChild(@NotNull String parent, @NotNull String child, boolean win) {
        String separator = RemoteFile.getSeparator(win);
        String path = parent.endsWith(separator) ? parent + child : parent + separator + child;
        return path;
    }

    private static String getSeparator(boolean win) {
        String separator = win ? "\\" : "/";
        return separator;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isWin() {
        return RemoteFile.isWindowsPath(this.myPath);
    }

    public static boolean isWindowsPath(@NotNull String path) {
        return (path = RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath(path)).length() > 1 && path.charAt(1) == ':';
    }

    private static String toSystemDependent(@NotNull String path, boolean isWin) {
        char separator = isWin ? (char)'\\' : '/';
        return FileUtil.toSystemIndependentName((String)path).replace('/', separator);
    }

    public static RemoteFileBuilder detectSystemByPath(@NotNull String path) {
        return new RemoteFileBuilder(RemoteFile.isWindowsPath(path));
    }

    public static RemoteFile createRemoteFile(String path, String script) {
        return RemoteFile.detectSystemByPath(path).createRemoteFile(path, script);
    }

    public static RemoteFile createRemoteFile(String path) {
        return RemoteFile.detectSystemByPath(path).createRemoteFile(path);
    }

    public static RemoteFile createRemoteFile(String path, String script, boolean isWindows) {
        return new RemoteFileBuilder(isWindows).createRemoteFile(path, script);
    }

    public static class RemoteFileBuilder {
        private final boolean isWin;

        private RemoteFileBuilder(boolean win) {
            this.isWin = win;
        }

        public RemoteFile createRemoteFile(String path) {
            return new RemoteFile(path, this.isWin);
        }

        public RemoteFile createRemoteFile(String path, String child) {
            return new RemoteFile(path, child, this.isWin);
        }
    }
}

