/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeReturnType
extends FixableUsageInfo {
    private final PsiMethod myMethod;
    private final String myType;

    public ChangeReturnType(@NotNull PsiMethod method, @NotNull String type) {
        super((PsiElement)method);
        this.myMethod = method;
        this.myType = type;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiTypeElement returnType = this.myMethod.getReturnTypeElement();
        assert (returnType != null) : this.myMethod;
        MutationUtils.replaceType(this.myType, returnType);
    }
}

