/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.util.Function;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaRefactoringUtil.class.getName()));

    @Nullable
    public static PsiExpression convertToMethodCallInLambdaBody(PsiMethodReferenceExpression element) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(element, false, true);
        return lambdaExpression != null ? LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody()) : null;
    }

    @Nullable
    public static PsiLambdaExpression convertMethodReferenceToLambda(final PsiMethodReferenceExpression referenceExpression, boolean ignoreCast, boolean simplifyToExpressionLambda) {
        PsiTypeCastExpression typeCastExpression;
        PsiLambdaExpression lambdaExpression;
        boolean isReceiver;
        PsiElement resolve = referenceExpression.resolve();
        PsiType functionalInterfaceType = referenceExpression.getFunctionalInterfaceType();
        PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (interfaceMethod == null) {
            return null;
        }
        final PsiSubstitutor psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult);
        MethodSignature signature = interfaceMethod.getSignature(psiSubstitutor);
        if (resolve instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            isReceiver = PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)referenceExpression, (MethodSignature)signature, (boolean)method.isVarArgs(), (boolean)method.hasModifierProperty("static"), (int)method.getParameterList().getParametersCount());
        } else {
            isReceiver = false;
        }
        final PsiParameter[] psiParameters = resolve instanceof PsiMethod ? ((PsiMethod)resolve).getParameterList().getParameters() : null;
        StringBuilder buf = new StringBuilder("(");
        LOG.assertTrue(functionalInterfaceType != null);
        buf.append(GenericsUtil.getVariableTypeByExpressionType((PsiType)functionalInterfaceType).getCanonicalText()).append(")(");
        final PsiParameterList parameterList = interfaceMethod.getParameterList();
        Object[] parameters = parameterList.getParameters();
        final HashMap map = new HashMap();
        final UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        final JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)referenceExpression.getProject());
        String paramsString = StringUtil.join((Object[])parameters, (Function)new Function<PsiParameter, String>(){

            public String fun(PsiParameter parameter) {
                String baseName;
                int parameterIndex = parameterList.getParameterIndex(parameter);
                if (isReceiver && parameterIndex == 0) {
                    SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, psiSubstitutor.substitute(parameter.getType()));
                    baseName = nameInfo.names.length > 0 ? nameInfo.names[0] : parameter.getName();
                } else {
                    String initialName;
                    if (psiParameters != null) {
                        int idx = parameterIndex - (isReceiver ? 1 : 0);
                        initialName = psiParameters.length > 0 ? psiParameters[idx < psiParameters.length ? idx : psiParameters.length - 1].getName() : parameter.getName();
                    } else {
                        initialName = parameter.getName();
                    }
                    baseName = codeStyleManager.variableNameToPropertyName(initialName, VariableKind.PARAMETER);
                }
                if (baseName != null) {
                    String parameterName = nameGenerator.generateUniqueName(codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)referenceExpression, true));
                    map.put(parameter, parameterName);
                    return parameterName;
                }
                return "";
            }
        }, (String)", ");
        buf.append(paramsString);
        buf.append(") -> ");
        JavaResolveResult resolveResult = referenceExpression.advancedResolve(false);
        PsiElement resolveElement = resolveResult.getElement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)referenceExpression.getProject());
        if (resolveElement instanceof PsiMember) {
            buf.append("{");
            if (!PsiType.VOID.equals((Object)interfaceMethod.getReturnType())) {
                buf.append("return ");
            }
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)referenceExpression);
            PsiElement qualifier = referenceExpression.getQualifier();
            PsiClass containingClass = qualifierResolveResult.getContainingClass();
            boolean onArrayRef = elementFactory.getArrayClass(PsiUtil.getLanguageLevel((PsiElement)referenceExpression)) == containingClass;
            PsiElement referenceNameElement = referenceExpression.getReferenceNameElement();
            if (isReceiver) {
                buf.append((String)map.get(parameters[0])).append(".");
            } else if (!(referenceNameElement instanceof PsiKeyword)) {
                if (qualifier instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement referenceElement = ((PsiTypeElement)qualifier).getInnermostComponentReferenceElement();
                    LOG.assertTrue(referenceElement != null);
                    if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)referenceExpression, (boolean)false)) {
                        buf.append(referenceElement.getReferenceName()).append(".");
                    }
                } else if (!(qualifier == null || qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass && ((PsiReferenceExpression)qualifier).getQualifier() == null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)referenceExpression, (boolean)false) || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null)) {
                    buf.append(qualifier.getText()).append(".");
                }
            }
            buf.append(referenceExpression.getReferenceName());
            if (referenceNameElement instanceof PsiKeyword) {
                buf.append(" ");
                if (onArrayRef) {
                    if (qualifier instanceof PsiTypeElement) {
                        PsiType type = ((PsiTypeElement)qualifier).getType();
                        int dim = type.getArrayDimensions();
                        buf.append(type.getDeepComponentType().getCanonicalText());
                        buf.append("[");
                        buf.append((String)map.get(parameters[0]));
                        buf.append("]");
                        while (--dim > 0) {
                            buf.append("[]");
                        }
                    }
                } else {
                    buf.append(((PsiMember)resolveElement).getName());
                    final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                    LOG.assertTrue(containingClass != null);
                    if (containingClass.hasTypeParameters() && !PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor)) {
                        buf.append("<").append(StringUtil.join((Object[])containingClass.getTypeParameters(), (Function)new Function<PsiTypeParameter, String>(){

                            public String fun(PsiTypeParameter parameter) {
                                PsiType psiType = substitutor.substitute(parameter);
                                LOG.assertTrue(psiType != null);
                                return psiType.getCanonicalText();
                            }
                        }, (String)", ")).append(">");
                    }
                }
            }
            if (!onArrayRef || isReceiver) {
                int i;
                buf.append("(");
                boolean first = true;
                int n = i = isReceiver ? 1 : 0;
                while (i < parameters.length) {
                    Object parameter = parameters[i];
                    if (!first) {
                        buf.append(", ");
                    } else {
                        first = false;
                    }
                    buf.append((String)map.get(parameter));
                    ++i;
                }
                buf.append(")");
            }
            buf.append(";}");
        }
        LOG.assertTrue((lambdaExpression = (PsiLambdaExpression)(typeCastExpression = (PsiTypeCastExpression)referenceExpression.replace((PsiElement)elementFactory.createExpressionFromText(buf.toString(), (PsiElement)referenceExpression))).getOperand()) != null, (Object)buf.toString());
        if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)typeCastExpression) || ignoreCast) {
            PsiExpression operand = typeCastExpression.getOperand();
            LOG.assertTrue(operand != null);
            lambdaExpression = (PsiLambdaExpression)typeCastExpression.replace((PsiElement)operand);
        }
        if (simplifyToExpressionLambda) {
            LambdaRefactoringUtil.simplifyToExpressionLambda(lambdaExpression);
        }
        return lambdaExpression;
    }

    public static void simplifyToExpressionLambda(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        PsiExpression singleExpression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant((PsiExpression)lambdaExpression, body);
        if (singleExpression != null) {
            body.replace((PsiElement)singleExpression);
        }
    }

    public static void removeSideEffectsFromLambdaBody(Editor editor, PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null && lambdaExpression.isValid()) {
            PsiElement body = lambdaExpression.getBody();
            PsiExpression methodCall = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body);
            PsiExpression qualifierExpression = null;
            if (methodCall instanceof PsiMethodCallExpression) {
                qualifierExpression = ((PsiMethodCallExpression)methodCall).getMethodExpression().getQualifierExpression();
            } else if (methodCall instanceof PsiNewExpression) {
                qualifierExpression = ((PsiNewExpression)methodCall).getQualifier();
            }
            if (qualifierExpression != null) {
                ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
                SideEffectChecker.checkSideEffects(qualifierExpression, sideEffects);
                if (!sideEffects.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)lambdaExpression.getProject(), (String)"There are possible side effects found in method reference qualifier.\nIntroduce local variable?", (String)"Side Effects Detected", (Icon)Messages.getQuestionIcon()) == 0)) {
                    qualifierExpression.putUserData(ElementToWorkOn.PARENT, (Object)lambdaExpression);
                    new IntroduceVariableHandler().invoke(qualifierExpression.getProject(), editor, qualifierExpression);
                }
            }
        }
    }
}

