/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class FixableUsagesRefactoringProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + FixableUsagesRefactoringProcessor.class.getName()));

    protected FixableUsagesRefactoringProcessor(Project project2) {
        super(project2);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usageInfos);
        for (UsageInfo usageInfo : usageInfos) {
            if (!(usageInfo instanceof FixableUsageInfo)) continue;
            try {
                ((FixableUsageInfo)usageInfo).fixUsage();
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    protected final UsageInfo[] findUsages() {
        List<FixableUsageInfo> usages = Collections.synchronizedList(new ArrayList());
        this.findUsages(usages);
        int numUsages = usages.size();
        UsageInfo[] usageArray = usages.toArray(new FixableUsageInfo[numUsages]);
        return usageArray;
    }

    protected abstract void findUsages(@NotNull List<FixableUsageInfo> var1);

    protected static void checkConflicts(Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo info : (UsageInfo[])refUsages.get()) {
            String conflict = ((FixableUsageInfo)info).getConflictMessage();
            if (conflict == null) continue;
            conflicts.putValue((Object)info.getElement(), (Object)XmlUtil.escape(conflict));
        }
    }
}

