/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeSelector {
    private final PsiType myType;
    private final JComponent myComponent;
    private final MyComboBoxModel myComboBoxModel;
    private final Project myProject;

    public TypeSelector(PsiType type, Project project2) {
        this.myType = type;
        this.myProject = project2;
        this.myComponent = new JLabel(this.myType.getPresentableText());
        this.myComboBoxModel = null;
    }

    public TypeSelector(Project project2) {
        this.myProject = project2;
        this.myComboBoxModel = new MyComboBoxModel();
        this.myComponent = new ComboBox();
        ((ComboBox)this.myComponent).setModel((ComboBoxModel)this.myComboBoxModel);
        this.myType = null;
    }

    public void setTypes(PsiType[] types) {
        if (this.myComboBoxModel == null) {
            return;
        }
        PsiType oldType = this.myComboBoxModel.getSize() > 0 ? this.getSelectedType() : null;
        this.myComboBoxModel.setSuggestions(TypeSelector.wrapToItems(types, this.myProject));
        if (oldType != null) {
            for (int i = 0; i < types.length; ++i) {
                PsiType type = types[i];
                if (!type.equals(oldType)) continue;
                ((JComboBox)this.myComponent).setSelectedIndex(i);
                return;
            }
        }
        if (types.length > 0) {
            ((JComboBox)this.myComponent).setSelectedIndex(0);
        }
    }

    public PsiType[] getTypes() {
        PsiType[] types = PsiType.createArray((int)this.myComboBoxModel.mySuggestions.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.myComboBoxModel.mySuggestions[i].getType();
        }
        return types;
    }

    private static PsiTypeItem[] wrapToItems(PsiType[] types, Project project2) {
        PsiTypeItem[] result = new PsiTypeItem[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PsiTypeItem(types[i], project2);
        }
        return result;
    }

    public void addItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).addItemListener(aListener);
        }
    }

    public void removeItemListener(ItemListener aListener) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).removeItemListener(aListener);
        }
    }

    public ItemListener[] getItemListeners() {
        if (this.myComponent instanceof JComboBox) {
            return ((JComboBox)this.myComponent).getItemListeners();
        }
        return new ItemListener[0];
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getFocusableComponent() {
        if (this.myComponent instanceof JComboBox) {
            return this.myComponent;
        }
        return null;
    }

    @Nullable
    public PsiType getSelectedType() {
        if (this.myComponent instanceof JLabel) {
            return this.myType;
        }
        PsiTypeItem selItem = (PsiTypeItem)((JComboBox)this.myComponent).getSelectedItem();
        return selItem == null ? null : selItem.getType();
    }

    public void selectType(@NotNull PsiType type) {
        if (this.myComponent instanceof JComboBox) {
            ((JComboBox)this.myComponent).setSelectedItem(new PsiTypeItem(type, this.myProject));
        }
    }

    private static class PsiTypeItem {
        private final PsiType myType;
        private final SmartTypePointer myTypePointer;

        private PsiTypeItem(PsiType type, Project project2) {
            this.myType = type;
            this.myTypePointer = SmartTypePointerManager.getInstance((Project)project2).createSmartTypePointer(type);
        }

        @Nullable
        public PsiType getType() {
            return this.myTypePointer.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiTypeItem that = (PsiTypeItem)o;
            return Comparing.equal((Object)this.getType(), (Object)that.getType());
        }

        public int hashCode() {
            PsiType type = this.getType();
            return type != null ? type.hashCode() : 0;
        }

        public String toString() {
            return this.myType.getPresentableText();
        }
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel {
        private PsiTypeItem[] mySuggestions = new PsiTypeItem[0];

        MyComboBoxModel() {
        }

        @Override
        public int getSize() {
            return this.mySuggestions.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.mySuggestions[index];
        }

        public void setSuggestions(PsiTypeItem[] suggestions) {
            this.fireIntervalRemoved(this, 0, this.mySuggestions.length);
            this.mySuggestions = suggestions;
            this.fireIntervalAdded(this, 0, this.mySuggestions.length);
        }
    }
}

