/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMemberSelectionTable<T extends PsiElement, M extends MemberInfoBase<T>>
extends JBTable
implements TypeSafeDataProvider {
    protected static final int CHECKED_COLUMN = 0;
    protected static final int DISPLAY_NAME_COLUMN = 1;
    protected static final int ABSTRACT_COLUMN = 2;
    protected static final Icon EMPTY_OVERRIDE_ICON = EmptyIcon.ICON_16;
    protected static final String DISPLAY_NAME_COLUMN_HEADER = RefactoringBundle.message((String)"member.column");
    protected static final int OVERRIDE_ICON_POSITION = 2;
    protected static final int VISIBILITY_ICON_POSITION = 1;
    protected static final int MEMBER_ICON_POSITION = 0;
    protected final String myAbstractColumnHeader;
    protected List<M> myMemberInfos;
    protected final boolean myAbstractEnabled;
    protected MemberInfoModel<T, M> myMemberInfoModel;
    protected MyTableModel<T, M> myTableModel;

    public AbstractMemberSelectionTable(Collection<M> memberInfos, @Nullable MemberInfoModel<T, M> memberInfoModel, @Nullable String abstractColumnHeader) {
        this.myAbstractEnabled = abstractColumnHeader != null;
        this.myAbstractColumnHeader = abstractColumnHeader;
        this.myTableModel = new MyTableModel(this);
        this.myMemberInfos = new ArrayList<M>(memberInfos);
        this.myMemberInfoModel = memberInfoModel != null ? memberInfoModel : new DefaultMemberInfoModel();
        this.setModel(this.myTableModel);
        TableColumnModel model = this.getColumnModel();
        model.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new MyTableRenderer(this)));
        TableColumn checkBoxColumn = model.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setCellRenderer((TableCellRenderer)((Object)new MyBooleanRenderer(this)));
        if (this.myAbstractEnabled) {
            int width = (int)(1.3 * (double)this.getFontMetrics(this.getFont()).charsWidth(this.myAbstractColumnHeader.toCharArray(), 0, this.myAbstractColumnHeader.length()));
            model.getColumn(2).setMaxWidth(width);
            model.getColumn(2).setPreferredWidth(width);
            model.getColumn(2).setCellRenderer((TableCellRenderer)((Object)new MyBooleanRenderer(this)));
        }
        this.setPreferredScrollableViewportSize(new Dimension(400, this.getRowHeight() * 12));
        this.getSelectionModel().setSelectionMode(2);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        new MyEnableDisableAction().register();
        new TableSpeedSearch((JTable)((Object)this));
    }

    public Collection<M> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> list = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info : this.myMemberInfos) {
            if (!this.isMemberInfoSelected(info)) continue;
            list.add(info);
        }
        return list;
    }

    private boolean isMemberInfoSelected(M info) {
        boolean memberEnabled = this.myMemberInfoModel.isMemberEnabled(info);
        return memberEnabled && info.isChecked() || !memberEnabled && this.myMemberInfoModel.isCheckedWhenDisabled(info);
    }

    public MemberInfoModel<T, M> getMemberInfoModel() {
        return this.myMemberInfoModel;
    }

    public void setMemberInfoModel(MemberInfoModel<T, M> memberInfoModel) {
        this.myMemberInfoModel = memberInfoModel;
    }

    public void fireExternalDataChange() {
        this.myTableModel.fireTableDataChanged();
    }

    public void redraw() {
        this.myTableModel.redraw(this.getSelectedMemberInfos());
        this.myTableModel.fireTableDataChanged();
    }

    public void setMemberInfos(Collection<M> memberInfos) {
        this.myMemberInfos = new ArrayList<M>(memberInfos);
        this.fireMemberInfoChange(memberInfos);
        this.myTableModel.fireTableDataChanged();
    }

    public void addMemberInfoChangeListener(MemberInfoChangeListener<T, M> l) {
        this.listenerList.add(MemberInfoChangeListener.class, l);
    }

    protected void fireMemberInfoChange(Collection<M> changedMembers) {
        Object[] list = this.listenerList.getListenerList();
        MemberInfoChange event = new MemberInfoChange(changedMembers);
        for (Object element : list) {
            if (!(element instanceof MemberInfoChangeListener)) continue;
            MemberInfoChangeListener changeListener = (MemberInfoChangeListener)element;
            changeListener.memberInfoChanged(event);
        }
    }

    public void calcData(DataKey key, DataSink sink) {
        Collection<M> memberInfos;
        if (key == CommonDataKeys.PSI_ELEMENT && (memberInfos = this.getSelectedMemberInfos()).size() > 0) {
            sink.put(CommonDataKeys.PSI_ELEMENT, (Object)((MemberInfoBase)memberInfos.iterator().next()).getMember());
        }
    }

    public void scrollSelectionInView() {
        for (int i = 0; i < this.myMemberInfos.size(); ++i) {
            if (!this.isMemberInfoSelected((MemberInfoBase)this.myMemberInfos.get(i))) continue;
            Rectangle rc = this.getCellRect(i, 0, false);
            this.scrollRectToVisible(rc);
            break;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.scrollSelectionInView();
    }

    @Nullable
    protected abstract Object getAbstractColumnValue(M var1);

    protected abstract boolean isAbstractColumnEditable(int var1);

    protected abstract void setVisibilityIcon(M var1, RowIcon var2);

    protected abstract Icon getOverrideIcon(M var1);

    protected Icon getMemberIcon(M memberInfo, @Iconable.IconFlags int flags) {
        return memberInfo.getMember().getIcon(flags);
    }

    private static class MyBooleanRenderer<T extends PsiElement, M extends MemberInfoBase<T>>
    extends BooleanTableCellRenderer {
        private final AbstractMemberSelectionTable<T, M> myTable;

        public MyBooleanRenderer(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JCheckBox) {
                int modelColumn = this.myTable.convertColumnIndexToModel(column);
                MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(row);
                component.setEnabled(modelColumn == 0 && this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo) || modelColumn == 2 && memberInfo.isChecked() && this.myTable.isAbstractColumnEditable(row));
            }
            return component;
        }
    }

    private static class MyTableRenderer<T extends PsiElement, M extends MemberInfoBase<T>>
    extends ColoredTableCellRenderer {
        private final AbstractMemberSelectionTable<T, M> myTable;

        public MyTableRenderer(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int modelColumn = this.myTable.convertColumnIndexToModel(column);
            MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(row);
            this.setToolTipText(this.myTable.myMemberInfoModel.getTooltipText(memberInfo));
            switch (modelColumn) {
                case 1: {
                    Icon memberIcon = this.myTable.getMemberIcon(memberInfo, 0);
                    Icon overrideIcon = this.myTable.getOverrideIcon(memberInfo);
                    RowIcon icon = new RowIcon(3);
                    icon.setIcon(memberIcon, 0);
                    this.myTable.setVisibilityIcon(memberInfo, icon);
                    icon.setIcon(overrideIcon, 2);
                    this.setIcon((Icon)icon);
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            this.setIconOpaque(false);
            this.setOpaque(false);
            boolean cellEditable = this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo);
            this.setEnabled(cellEditable);
            if (value == null) {
                return;
            }
            int problem = this.myTable.myMemberInfoModel.checkForProblems(memberInfo);
            JBColor c = null;
            if (problem == 2) {
                c = JBColor.RED;
            } else if (problem == 1 && !isSelected) {
                c = JBColor.BLUE;
            }
            this.append((String)value, new SimpleTextAttributes(0, (Color)c));
        }
    }

    private class MyEnableDisableAction
    extends EnableDisableAction {
        private MyEnableDisableAction() {
        }

        @Override
        protected JTable getTable() {
            return AbstractMemberSelectionTable.this;
        }

        @Override
        protected void applyValue(int[] rows, boolean valueToBeSet) {
            ArrayList<MemberInfoBase> changedInfo = new ArrayList<MemberInfoBase>();
            for (int row : rows) {
                MemberInfoBase memberInfo = (MemberInfoBase)AbstractMemberSelectionTable.this.myMemberInfos.get(row);
                memberInfo.setChecked(valueToBeSet);
                changedInfo.add(memberInfo);
            }
            AbstractMemberSelectionTable.this.fireMemberInfoChange(changedInfo);
            int[] selectedRows = AbstractMemberSelectionTable.this.getSelectedRows();
            AbstractMemberSelectionTable.this.myTableModel.fireTableDataChanged();
            ListSelectionModel selectionModel = AbstractMemberSelectionTable.this.getSelectionModel();
            for (int selectedRow : selectedRows) {
                selectionModel.addSelectionInterval(selectedRow, selectedRow);
            }
        }

        @Override
        protected boolean isRowChecked(int row) {
            return ((MemberInfoBase)AbstractMemberSelectionTable.this.myMemberInfos.get(row)).isChecked();
        }
    }

    protected static class MyTableModel<T extends PsiElement, M extends MemberInfoBase<T>>
    extends AbstractTableModel {
        private final AbstractMemberSelectionTable<T, M> myTable;

        public MyTableModel(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        @Override
        public int getColumnCount() {
            if (this.myTable.myAbstractEnabled) {
                return 3;
            }
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myTable.myMemberInfos.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo)) {
                        return memberInfo.isChecked();
                    }
                    return this.myTable.myMemberInfoModel.isCheckedWhenDisabled(memberInfo);
                }
                case 2: {
                    return this.myTable.getAbstractColumnValue(memberInfo);
                }
                case 1: {
                    return memberInfo.getDisplayName();
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 2: {
                    return this.myTable.myAbstractColumnHeader;
                }
                case 1: {
                    return DISPLAY_NAME_COLUMN_HEADER;
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myTable.myMemberInfoModel.isMemberEnabled((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex));
                }
                case 2: {
                    return this.myTable.isAbstractColumnEditable(rowIndex);
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex)).setChecked(((Boolean)aValue).booleanValue());
            } else if (columnIndex == 2) {
                ((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex)).setToAbstract(((Boolean)aValue).booleanValue());
            }
            List changed = Collections.singletonList(this.myTable.myMemberInfos.get(rowIndex));
            this.redraw(changed);
        }

        public void redraw(Collection<M> changed) {
            this.myTable.fireMemberInfoChange(changed);
            this.fireTableDataChanged();
        }
    }

    private static class DefaultMemberInfoModel<T extends PsiElement, M extends MemberInfoBase<T>>
    implements MemberInfoModel<T, M> {
        private DefaultMemberInfoModel() {
        }

        public boolean isMemberEnabled(M member) {
            return true;
        }

        public boolean isCheckedWhenDisabled(M member) {
            return false;
        }

        public boolean isAbstractEnabled(M member) {
            return true;
        }

        public boolean isAbstractWhenDisabled(M member) {
            return false;
        }

        public int checkForProblems(@NotNull M member) {
            return 0;
        }

        public void memberInfoChanged(MemberInfoChange<T, M> event) {
        }

        public Boolean isFixedAbstract(M member) {
            return null;
        }

        public String getTooltipText(M member) {
            return null;
        }
    }
}

