/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.ui.MigrationConflictsPanel;
import com.intellij.refactoring.typeMigration.ui.MigrationNode;
import com.intellij.refactoring.typeMigration.ui.MigrationRootNode;
import com.intellij.refactoring.typeMigration.ui.MigrationUsagesPanel;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationTreeBuilder;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsagePresentation;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationPanel
extends JPanel
implements Disposable {
    @NonNls
    private static final String MIGRATION_USAGES = "migration.usages";
    private static final DataKey<TypeMigrationUsageInfo[]> MIGRATION_USAGES_KEYS = DataKey.create((String)"migration.usages");
    private final PsiElement[] myInitialRoots;
    private final TypeMigrationLabeler myLabeler;
    private final MyTree myRootsTree;
    private final Project myProject;
    private Content myContent;
    private final MigrationUsagesPanel myUsagesPanel;
    private final MigrationConflictsPanel myConflictsPanel;

    public MigrationPanel(PsiElement[] roots, TypeMigrationLabeler labeler, Project project2, boolean previewUsages) {
        super(new BorderLayout());
        this.myInitialRoots = roots;
        this.myLabeler = labeler;
        this.myProject = project2;
        this.myRootsTree = new MyTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
        final TypeMigrationTreeBuilder builder = new TypeMigrationTreeBuilder((JTree)((Object)this.myRootsTree), project2);
        final MigrationRootNode currentRoot = new MigrationRootNode(project2, this.myLabeler, roots, previewUsages);
        builder.setRoot(currentRoot);
        this.initTree(this.myRootsTree);
        this.myRootsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MigrationPanel.this.selectionChanged();
            }
        });
        final Splitter treeSplitter = new Splitter();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                treeSplitter.dispose();
            }
        });
        treeSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRootsTree)));
        this.myUsagesPanel = new MigrationUsagesPanel(this.myProject);
        treeSplitter.setSecondComponent((JComponent)this.myUsagesPanel);
        Disposer.register((Disposable)this, (Disposable)this.myUsagesPanel);
        this.add((Component)this.createToolbar(), "South");
        final Splitter conflictsSplitter = new Splitter(true, 0.8f);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                conflictsSplitter.dispose();
            }
        });
        conflictsSplitter.setFirstComponent((JComponent)treeSplitter);
        this.myConflictsPanel = new MigrationConflictsPanel(this.myProject);
        conflictsSplitter.setSecondComponent((JComponent)this.myConflictsPanel);
        this.add((Component)conflictsSplitter, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myConflictsPanel);
        builder.addSubtreeToUpdate((DefaultMutableTreeNode)this.myRootsTree.getModel().getRoot(), new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (builder.isDisposed()) {
                            return;
                        }
                        MigrationPanel.this.myRootsTree.expandPath(new TreePath(MigrationPanel.this.myRootsTree.getModel().getRoot()));
                        Collection<? extends AbstractTreeNode> children2 = currentRoot.getChildren();
                        if (!children2.isEmpty()) {
                            builder.select(children2.iterator().next());
                        }
                    }
                });
            }
        });
        Disposer.register((Disposable)this, (Disposable)builder);
    }

    private void selectionChanged() {
        this.myConflictsPanel.setToInitialPosition();
        this.myUsagesPanel.setToInitialPosition();
        DefaultMutableTreeNode[] migrationNodes = (DefaultMutableTreeNode[])this.myRootsTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (migrationNodes.length == 0) {
            return;
        }
        Object userObject = migrationNodes[0].getUserObject();
        if (userObject instanceof MigrationNode) {
            AbstractTreeNode rootNode;
            MigrationNode migrationNode = (MigrationNode)userObject;
            UsageInfo[] failedUsages = this.myLabeler.getFailedUsages(migrationNode.getInfo());
            if (failedUsages.length > 0) {
                this.myConflictsPanel.showUsages(PsiElement.EMPTY_ARRAY, failedUsages);
            }
            if ((rootNode = migrationNode.getParent()) instanceof MigrationNode) {
                this.myUsagesPanel.showRootUsages(((MigrationNode)rootNode).getInfo(), migrationNode.getInfo(), this.myLabeler);
            }
        }
    }

    private JComponent createToolbar() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0);
        JButton performButton = new JButton(RefactoringBundle.message((String)"type.migration.migrate.button.text"));
        performButton.addActionListener(new ActionListener(){

            private void expandTree(MigrationNode migrationNode) {
                if (!migrationNode.getInfo().isExcluded() || migrationNode.areChildrenInitialized()) {
                    Collection<? extends AbstractTreeNode> nodes = migrationNode.getChildren();
                    for (final AbstractTreeNode abstractTreeNode : nodes) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                this.expandTree((MigrationNode)abstractTreeNode);
                            }
                        });
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object userObject;
                Object root = MigrationPanel.this.myRootsTree.getModel().getRoot();
                if (root instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)root).getUserObject()) instanceof MigrationRootNode) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                        @Override
                        public void run() {
                            final HashSet files = new HashSet();
                            final TypeMigrationUsageInfo[] usages = (TypeMigrationUsageInfo[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<TypeMigrationUsageInfo[]>(){

                                public TypeMigrationUsageInfo[] compute() {
                                    TypeMigrationUsageInfo[] usages;
                                    Collection<? extends AbstractTreeNode> children2 = ((MigrationRootNode)userObject).getChildren();
                                    for (AbstractTreeNode abstractTreeNode : children2) {
                                        this.expandTree((MigrationNode)abstractTreeNode);
                                    }
                                    for (TypeMigrationUsageInfo usage : usages = MigrationPanel.this.myLabeler.getMigratedUsages()) {
                                        PsiElement element;
                                        if (usage.isExcluded() || (element = usage.getElement()) == null) continue;
                                        files.add((Object)element.getContainingFile().getVirtualFile());
                                    }
                                    return usages;
                                }
                            });
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ReadonlyStatusHandler.getInstance((Project)MigrationPanel.this.myProject).ensureFilesWritable(VfsUtilCore.toVirtualFileArray((Collection)files)).hasReadonlyFiles()) {
                                        return;
                                    }
                                    new WriteCommandAction(MigrationPanel.this.myProject, new PsiFile[0]){

                                        protected void run(@NotNull Result result) throws Throwable {
                                            TypeMigrationProcessor.change(MigrationPanel.this.myLabeler, usages);
                                        }
                                    }.execute();
                                }
                            }, MigrationPanel.this.myProject.getDisposed());
                        }
                    }, "Type Migration", false, MigrationPanel.this.myProject);
                }
                UsageViewManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
            }
        });
        panel.add((Component)performButton, gc);
        JButton closeButton = new JButton(CommonBundle.getCancelButtonText());
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageViewManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
            }
        });
        panel.add((Component)closeButton, gc);
        JButton rerunButton = new JButton(RefactoringBundle.message((String)"type.migration.rerun.button.text"));
        rerunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageViewManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TypeMigrationDialog.MultipleElements dialog = new TypeMigrationDialog.MultipleElements(MigrationPanel.this.myProject, MigrationPanel.this.myInitialRoots, MigrationPanel.this.myLabeler.getMigrationRootTypeFunction(), MigrationPanel.this.myLabeler.getRules());
                        dialog.show();
                    }
                });
            }
        });
        panel.add((Component)rerunButton, gc);
        JButton helpButton = new JButton(CommonBundle.getHelpButtonText());
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpManager.getInstance().invokeHelp("reference.typeMigrationPreview");
            }
        });
        gc.weightx = 1.0;
        panel.add((Component)helpButton, gc);
        return panel;
    }

    private void initTree(Tree tree) {
        MigrationRootsTreeCellRenderer rootsTreeCellRenderer = new MigrationRootsTreeCellRenderer();
        tree.setCellRenderer((TreeCellRenderer)((Object)rootsTreeCellRenderer));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        TreeUtil.expandAll((JTree)tree);
        SmartExpander.installOn((JTree)tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (ActionManager)ActionManager.getInstance());
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ExcludeAction());
        group.add((AnAction)new IncludeAction());
        group.addSeparator();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("EditSource"));
        group.add(actionManager.getAction("VersionControlsGroup"));
        return group;
    }

    public void dispose() {
    }

    public void setContent(Content content) {
        this.myContent = content;
        Disposer.register((Disposable)content, (Disposable)this);
    }

    private static class MigrationRootsTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MigrationRootsTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (!(userObject instanceof MigrationNode)) {
                return;
            }
            TypeMigrationUsageInfo usageInfo = ((MigrationNode)userObject).getInfo();
            if (usageInfo != null) {
                PsiElement element = usageInfo.getElement();
                if (element != null) {
                    String location;
                    PsiTypeElement typeElement = null;
                    if (element instanceof PsiVariable) {
                        typeElement = ((PsiVariable)element).getTypeElement();
                    } else if (element instanceof PsiMethod) {
                        typeElement = ((PsiMethod)element).getReturnTypeElement();
                    }
                    if (typeElement == null) {
                        typeElement = element;
                    }
                    PsiDocumentManager.getInstance((Project)element.getProject()).commitAllDocuments();
                    UsagePresentation presentation = UsageInfoToUsageConverter.convert((PsiElement[])new PsiElement[]{typeElement}, (UsageInfo)new UsageInfo((PsiElement)typeElement)).getPresentation();
                    boolean isPrefix = true;
                    for (TextChunk chunk : presentation.getText()) {
                        if (!isPrefix) {
                            this.append(chunk.getText(), MigrationRootsTreeCellRenderer.patchAttrs(usageInfo, chunk.getSimpleAttributesIgnoreBackground()));
                        }
                        isPrefix = false;
                    }
                    this.setIcon(presentation.getIcon());
                    if (element instanceof PsiMember) {
                        location = SymbolPresentationUtil.getSymbolContainerText(element);
                    } else {
                        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
                        location = member instanceof PsiField ? PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)member), (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY) : (member instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)member), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)2) : (member instanceof PsiClass ? PsiFormatUtil.formatClass((PsiClass)((PsiClass)member), (int)2049) : null));
                        if (location != null) {
                            location = PsiBundle.message((String)"aux.context.display", (Object[])new Object[]{location});
                        }
                    }
                    if (location != null) {
                        this.append(location, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                } else {
                    this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        private static SimpleTextAttributes patchAttrs(TypeMigrationUsageInfo usageInfo, SimpleTextAttributes original) {
            if (usageInfo.isExcluded()) {
                original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
            }
            return original;
        }
    }

    private abstract class ExcludeIncludeActionBase
    extends AnAction {
        protected abstract void processUsage(TypeMigrationUsageInfo var1);

        ExcludeIncludeActionBase(String text) {
            super(text);
        }

        @Nullable
        private TypeMigrationUsageInfo[] getUsages(AnActionEvent context) {
            return (TypeMigrationUsageInfo[])MIGRATION_USAGES_KEYS.getData(context.getDataContext());
        }

        public void update(AnActionEvent e) {
            TreePath[] selectionPaths = MigrationPanel.this.myRootsTree.getSelectionPaths();
            e.getPresentation().setEnabled(selectionPaths != null && selectionPaths.length > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            TypeMigrationUsageInfo[] usages = this.getUsages(e);
            assert (usages != null);
            for (TypeMigrationUsageInfo usageInfo : usages) {
                this.processUsage(usageInfo);
            }
            MigrationPanel.this.myRootsTree.repaint();
        }
    }

    private class IncludeAction
    extends ExcludeIncludeActionBase {
        public IncludeAction() {
            super(RefactoringBundle.message((String)"type.migration.include.action.text"));
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)MigrationPanel.this.myRootsTree));
        }

        @Override
        protected void processUsage(TypeMigrationUsageInfo usageInfo) {
            usageInfo.setExcluded(false);
        }

        @Override
        public void update(AnActionEvent e) {
            DefaultMutableTreeNode[] selectedNodes;
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            for (DefaultMutableTreeNode node : selectedNodes = (DefaultMutableTreeNode[])MigrationPanel.this.myRootsTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof MigrationNode)) {
                    return;
                }
                AbstractTreeNode parent = ((MigrationNode)userObject).getParent();
                if (!(parent instanceof MigrationNode) || !((MigrationNode)parent).getInfo().isExcluded()) continue;
                return;
            }
            presentation.setEnabled(true);
        }
    }

    private class ExcludeAction
    extends ExcludeIncludeActionBase {
        public ExcludeAction() {
            super(RefactoringBundle.message((String)"type.migration.exclude.action.text"));
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)MigrationPanel.this.myRootsTree));
        }

        @Override
        protected void processUsage(TypeMigrationUsageInfo usageInfo) {
            usageInfo.setExcluded(true);
        }
    }

    private static class MyTree
    extends Tree
    implements DataProvider {
        private MyTree(TreeModel treemodel) {
            super(treemodel);
        }

        protected void paintComponent(Graphics g) {
            DuplicateNodeRenderer.paintDuplicateNodesBackground(g, (JTree)((Object)this));
            super.paintComponent(g);
        }

        public Object getData(@NonNls String dataId) {
            if ("psi.Element".equals(dataId)) {
                DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.getSelectedNodes(DefaultMutableTreeNode.class, null);
                return selectedNodes.length == 1 && selectedNodes[0].getUserObject() instanceof MigrationNode ? ((MigrationNode)selectedNodes[0].getUserObject()).getInfo().getElement() : null;
            }
            if (MigrationPanel.MIGRATION_USAGES.equals(dataId)) {
                DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.getSelectedNodes(DefaultMutableTreeNode.class, null);
                HashSet usageInfos = new HashSet();
                for (DefaultMutableTreeNode selectedNode : selectedNodes) {
                    Object userObject = selectedNode.getUserObject();
                    if (!(userObject instanceof MigrationNode)) continue;
                    MyTree.collectInfos((Set<TypeMigrationUsageInfo>)usageInfos, (MigrationNode)userObject);
                }
                return usageInfos.toArray(new TypeMigrationUsageInfo[usageInfos.size()]);
            }
            return null;
        }

        private static void collectInfos(Set<TypeMigrationUsageInfo> usageInfos, MigrationNode currentNode) {
            usageInfos.add(currentNode.getInfo());
            if (!currentNode.areChildrenInitialized()) {
                return;
            }
            Collection<? extends AbstractTreeNode> nodes = currentNode.getChildren();
            for (AbstractTreeNode abstractTreeNode : nodes) {
                MyTree.collectInfos(usageInfos, (MigrationNode)abstractTreeNode);
            }
        }
    }
}

