/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FunctionalInterfaceTypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaLambdaConversionRule
extends BaseGuavaTypeConversionRule {
    private final GuavaLambda myLambda;

    protected GuavaLambdaConversionRule(GuavaLambda lambda2) {
        this.myLambda = lambda2;
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put(this.myLambda.getSamName(), new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName()));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, PsiExpression context) {
        return new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName());
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        return this.myLambda.getClassQName();
    }

    @Override
    @NotNull
    public String ruleToClass() {
        return this.myLambda.getJavaAnalogueClassQName();
    }

    public static class Supplier
    extends GuavaLambdaConversionRule {
        public Supplier() {
            super(GuavaLambda.SUPPLIER);
        }
    }

    public static class Function
    extends GuavaLambdaConversionRule {
        public Function() {
            super(GuavaLambda.FUNCTION);
        }
    }
}

