/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.Nullable;

public enum GuavaLambda {
    PREDICATE("com.google.common.base.Predicate", "java.util.function.Predicate", "apply", "test"),
    FUNCTION("com.google.common.base.Function", "java.util.function.Function", "apply", "apply"),
    SUPPLIER("com.google.common.base.Supplier", "java.util.function.Supplier", "get", "get");

    private final String myClassQName;
    private final String myJavaAnalogueClassQName;
    private final String mySamName;
    private final String myJavaAnalogueSamName;

    private GuavaLambda(String classQName, String javaAnalogueClassQName, String samName, String javaAnalogueSamName) {
        this.myClassQName = classQName;
        this.myJavaAnalogueClassQName = javaAnalogueClassQName;
        this.mySamName = samName;
        this.myJavaAnalogueSamName = javaAnalogueSamName;
    }

    public String getClassQName() {
        return this.myClassQName;
    }

    public String getJavaAnalogueClassQName() {
        return this.myJavaAnalogueClassQName;
    }

    public String getSamName() {
        return this.mySamName;
    }

    public String getJavaAnalogueSamName() {
        return this.myJavaAnalogueSamName;
    }

    @Nullable
    static GuavaLambda findFor(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (aClass == null) {
            return null;
        }
        for (GuavaLambda lambda2 : GuavaLambda.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)lambda2.getClassQName())) continue;
            return lambda2;
        }
        return null;
    }

    @Nullable
    static GuavaLambda findJavaAnalogueFor(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (aClass == null) {
            return null;
        }
        for (GuavaLambda lambda2 : GuavaLambda.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)lambda2.getJavaAnalogueClassQName())) continue;
            return lambda2;
        }
        return null;
    }
}

