/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeClassParametersIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeClassParametersIntention.class));

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Change class type parameter";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiMember member;
        PsiReferenceParameterList parameterList;
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class);
        PsiElement parent = typeElement != null ? typeElement.getParent() : null;
        PsiReferenceParameterList psiReferenceParameterList = parameterList = parent instanceof PsiReferenceParameterList ? (PsiReferenceParameterList)parent : null;
        if (parameterList != null && parameterList.getTypeArguments().length > 0 && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)parameterList, PsiMember.class)) instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)member).getBaseClassType().resolveGenerics();
            PsiClass baseClass = result.getElement();
            return baseClass != null && baseClass.getTypeParameters().length == parameterList.getTypeParameterElements().length && ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == parameterList;
        }
        return false;
    }

    public void invoke(final @NotNull Project project2, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass aClass;
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class);
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiReferenceParameterList.class);
        if (parameterList != null && (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiAnonymousClass) {
            editor.getCaretModel().moveToOffset(aClass.getTextOffset());
            Object[] typeElements = parameterList.getTypeParameterElements();
            int changeIdx = ArrayUtil.find((Object[])typeElements, (Object)typeElement);
            final PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            final PsiClass baseClass = result.getElement();
            LOG.assertTrue(baseClass != null);
            final PsiTypeParameter typeParameter = baseClass.getTypeParameters()[changeIdx];
            TemplateBuilderImpl templateBuilder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)aClass);
            final String oldTypeText = typeElement.getText();
            String varName = "param";
            templateBuilder.replaceElement((PsiElement)typeElement, "param", (Expression)new TypeExpression(project2, new PsiType[]{typeElement.getType()}), true);
            Template template = templateBuilder.buildInlineTemplate();
            TemplateManager.getInstance(project2).startTemplate(editor, template, false, null, new TemplateEditingAdapter(){
                private String myNewType;

                @Override
                public void beforeTemplateFinished(TemplateState state, Template template) {
                    TextResult value = state.getVariableValue("param");
                    this.myNewType = value != null ? value.getText() : "";
                    int segmentsCount = state.getSegmentsCount();
                    Document document = state.getEditor().getDocument();
                    for (int i = 0; i < segmentsCount; ++i) {
                        TextRange segmentRange = state.getSegmentRange(i);
                        document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), (CharSequence)oldTypeText);
                    }
                }

                @Override
                public void templateFinished(Template template, boolean brokenOff) {
                    if (!brokenOff) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                        try {
                            PsiType targetParam = elementFactory.createTypeFromText(this.myNewType, (PsiElement)aClass);
                            if (!(targetParam instanceof PsiClassType)) {
                                HintManager.getInstance().showErrorHint(editor, JavaErrorMessages.message("generics.type.argument.cannot.be.of.primitive.type", new Object[0]));
                                return;
                            }
                            PsiClassType classType = (PsiClassType)targetParam;
                            PsiClass target = classType.resolve();
                            if (target == null) {
                                HintManager.getInstance().showErrorHint(editor, JavaErrorMessages.message("cannot.resolve.symbol", classType.getPresentableText()));
                                return;
                            }
                            TypeMigrationRules myRules = new TypeMigrationRules();
                            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, targetParam);
                            PsiClassType targetClassType = elementFactory.createType(baseClass, substitutor);
                            myRules.setBoundScope((SearchScope)new LocalSearchScope((PsiElement)aClass));
                            TypeMigrationProcessor.runHighlightingTypeMigration(project2, editor, myRules, (PsiElement)((PsiAnonymousClass)aClass).getBaseClassReference().getParameterList(), (PsiType)targetClassType);
                        }
                        catch (IncorrectOperationException e) {
                            HintManager.getInstance().showErrorHint(editor, "Incorrect type");
                        }
                    }
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

