/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationVariableTypeFixProvider
implements ChangeVariableTypeQuickFixProvider {
    private static final Logger LOG1 = Logger.getInstance((String)("#" + TypeMigrationVariableTypeFixProvider.class.getName()));

    @NotNull
    public IntentionAction[] getFixes(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        return new IntentionAction[]{TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn)};
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        return TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn, false);
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn, final boolean optimizeImports) {
        return new VariableTypeFix(variable, toReturn){

            @Override
            @NotNull
            public String getText() {
                return "Migrate '" + this.myName + "' type to '" + this.getReturnType().getCanonicalText() + "'";
            }

            @Override
            public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)startElement, this.getReturnType(), editor, optimizeImports);
            }

            @Override
            public boolean startInWriteAction() {
                return false;
            }
        };
    }

    public static void runTypeMigrationOnVariable(@NotNull PsiVariable variable, @NotNull PsiType targetType, @Nullable(value="is null when called from inspection") Editor editor, boolean optimizeImports) {
        Project project2 = variable.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(variable.getContainingFile())) {
            return;
        }
        try {
            variable.normalizeDeclaration();
            TypeMigrationRules rules = new TypeMigrationRules();
            rules.setBoundScope((SearchScope)GlobalSearchScope.projectScope((Project)project2));
            TypeMigrationProcessor.runHighlightingTypeMigration(project2, editor, rules, (PsiElement)variable, targetType, optimizeImports);
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)variable);
            UndoUtil.markPsiFileForUndo((PsiFile)variable.getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG1.error((Throwable)e);
        }
    }
}

