/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.usageInfo.OverridenUsageInfo;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;

class MigrateGetterNameSetting {
    private static final String CODE_ALWAYS_YES = "Always Migrate Method Names";
    private static final String CODE_ALWAYS_NO = "Never Migrate Method Names";
    private static final String[] CODES = new String[]{"Always Migrate Method Names", Messages.YES_BUTTON, "Never Migrate Method Names", Messages.NO_BUTTON};
    private final AtomicReference<Boolean> myGlobalValue = new AtomicReference();

    MigrateGetterNameSetting() {
    }

    void askUserIfNeed(final OverridenUsageInfo info, final String newMethodName, PsiType migrationReturnType) {
        Boolean globalValue = this.myGlobalValue.get();
        if (globalValue == null) {
            String currentName = ((PsiMethod)info.getElement()).getName();
            final String messageText = String.format("Do migrate getter name from '%s' to '%s' since return type is migrated to '%s'?", currentName, newMethodName, migrationReturnType.getCanonicalText());
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    Boolean globalValue = (Boolean)MigrateGetterNameSetting.this.myGlobalValue.get();
                    if (globalValue == null) {
                        int code = MigrateGetterNameSetting.showChooserDialog(messageText);
                        if (code == 0) {
                            MigrateGetterNameSetting.this.myGlobalValue.set(true);
                            info.setMigrateMethodName(newMethodName);
                        } else if (code == 1) {
                            info.setMigrateMethodName(newMethodName);
                        } else if (code == 2) {
                            MigrateGetterNameSetting.this.myGlobalValue.set(false);
                        }
                    } else if (globalValue.equals(Boolean.TRUE)) {
                        info.setMigrateMethodName(newMethodName);
                    }
                }
            });
        } else if (globalValue.equals(Boolean.TRUE)) {
            info.setMigrateMethodName(newMethodName);
        }
    }

    private static int showChooserDialog(String messageText) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return messageText.contains("dontMigrateName") ? 3 : 1;
        }
        return Messages.showIdeaMessageDialog(null, (String)messageText, (String)"Type Migration", (String[])CODES, (int)0, null, null);
    }
}

