/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeSignatureHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeTypeSignatureHandler.class.getName()));
    public static final String REFACTORING_NAME = "Type Migration";

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement element = file2.findElementAt(offset);
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent = typeElement.getParent();
            if (parent instanceof PsiVariable || parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
                ChangeTypeSignatureHandler.invoke(project2, parent, null, null, editor);
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"The caret should be positioned on type of field, variable, method or method parameter to be refactored", (String)REFACTORING_NAME, (String)"refactoring.migrateType");
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project2, element);
    }

    public static boolean invokeOnElement(Project project2, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile) {
            ChangeTypeSignatureHandler.invoke(project2, element, null, null, null);
            return true;
        }
        if (ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project2, element, null, null, null);
            return true;
        }
        return false;
    }

    protected static boolean isClassArgument(PsiElement element) {
        if (element instanceof PsiReferenceParameterList) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == element;
            }
            if (member instanceof PsiClass) {
                PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
                PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
                return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
            }
        }
        return false;
    }

    public static void invoke(Project project2, PsiElement root, PsiType type, TypeMigrationRules rules, Editor editor) {
        if (Util.canBeMigrated(root)) {
            TypeMigrationDialog.SingleElement dialog = new TypeMigrationDialog.SingleElement(project2, root, type, rules);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered"), (String)RefactoringBundle.message((String)"unable.to.start.type.migration"), null);
    }
}

