/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.panels.ValidatingComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class AutomaticUsageRenamingDialog<T>
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.AutomaticRenamingDialog");
    private static final int CHECK_COLUMN = 0;
    private static final int OLD_NAME_COLUMN = 1;
    private static final int NEW_NAME_COLUMN = 2;
    private final AutomaticUsageRenamer<T> myRenamer;
    private boolean[] myShouldRename;
    private String[] myNewNames;
    private MyTableModel myTableModel;
    private JBTable myTable;
    private DocumentAdapter myCellEditorListener;
    private ValidatingComponent myValidatingComponent;

    public AutomaticUsageRenamingDialog(Project project2, AutomaticUsageRenamer<T> renamer) {
        super(project2, true);
        this.myRenamer = renamer;
        this.populateData();
        this.setTitle(this.myRenamer.getDialogTitle());
        this.setOKButtonText(IdeBundle.message((String)"button.ok", (Object[])new Object[0]));
        this.init();
    }

    private void populateData() {
        this.myNewNames = new String[this.getElementCount()];
        this.myShouldRename = new boolean[this.getElementCount()];
        for (int i = 0; i < this.getElementCount(); ++i) {
            this.myNewNames[i] = this.myRenamer.getNewElementName(this.getElements().get(i));
            this.myShouldRename[i] = this.myRenamer.isCheckedInitially(this.getElements().get(i));
        }
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.rename.AutomaticRenamingDialog";
    }

    private int getElementCount() {
        return this.getElements().size();
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(this.myRenamer.getDialogDescription()));
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public void show() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        super.show();
    }

    protected void handleChanges() {
        this.updateRenamer();
        boolean okActionEnabled = true;
        for (T element : this.getElements()) {
            String errorText = this.getErrorText(element);
            if (errorText == null) continue;
            okActionEnabled = false;
        }
        this.setOKActionEnabled(okActionEnabled);
        this.refreshValidatingComponent();
    }

    private void refreshValidatingComponent() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.myValidatingComponent.setErrorText(this.getErrorText(this.getElements().get(selectedRow)));
        }
    }

    @Nullable
    private String getErrorText(T element) {
        return this.isChecked(element) ? this.myRenamer.getErrorText(element) : null;
    }

    private static SimpleTextAttributes highlightIfNeeded(SimpleTextAttributes attributes, String errorText) {
        if (errorText != null) {
            Color errorColor = SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor();
            int style = attributes.getStyle() | 2 | 8;
            return new SimpleTextAttributes(style, errorColor, errorColor);
        }
        return attributes;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        Box box = Box.createVerticalBox();
        this.setupTable();
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AutomaticUsageRenamingDialog.this.handleChanges();
            }
        });
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        this.setupOldNameColumn();
        this.setupNewNameColumn();
        this.myValidatingComponent = new ValidatingComponent(){

            protected JComponent createMainComponent() {
                return ScrollPaneFactory.createScrollPane((Component)AutomaticUsageRenamingDialog.this.myTable);
            }
        };
        this.myValidatingComponent.doInitialize();
        box.add((Component)this.myValidatingComponent);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        JButton selectAllButton = new JButton(RefactoringBundle.message((String)"select.all.button"));
        buttonBox.add(selectAllButton);
        buttonBox.add(Box.createHorizontalStrut(4));
        JButton deselectAllButton = new JButton(RefactoringBundle.message((String)"unselect.all.button"));
        buttonBox.add(deselectAllButton);
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AutomaticUsageRenamingDialog.this.getElementCount(); ++i) {
                    ((AutomaticUsageRenamingDialog)AutomaticUsageRenamingDialog.this).myShouldRename[i] = true;
                }
                AutomaticUsageRenamingDialog.this.myTableModel.fireTableDataChanged();
            }
        });
        selectAllButton.setMnemonic('S');
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AutomaticUsageRenamingDialog.this.getElementCount(); ++i) {
                    ((AutomaticUsageRenamingDialog)AutomaticUsageRenamingDialog.this).myShouldRename[i] = false;
                }
                AutomaticUsageRenamingDialog.this.myTableModel.fireTableDataChanged();
            }
        });
        deselectAllButton.setMnemonic('U');
        box.add(Box.createVerticalStrut(4));
        box.add(buttonBox);
        box.add(Box.createVerticalStrut(4));
        return box;
    }

    private void setupTable() {
        this.myTable = new JBTable();
        this.myTableModel = new MyTableModel();
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AutomaticUsageRenamingDialog.this.refreshValidatingComponent();
            }
        });
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setRowSelectionAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
    }

    private void setupNewNameColumn() {
        this.myTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Object element = AutomaticUsageRenamingDialog.this.getElements().get(row);
                String errorText = AutomaticUsageRenamingDialog.this.getErrorText(element);
                this.setToolTipText(errorText);
                this.append(String.valueOf(value), AutomaticUsageRenamingDialog.highlightIfNeeded(SimpleTextAttributes.REGULAR_ATTRIBUTES, errorText));
            }
        });
        final JTextField textField = new JTextField("");
        textField.setBorder((Border)JBUI.Borders.empty());
        this.myTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(textField){

            @Override
            public boolean stopCellEditing() {
                AutomaticUsageRenamingDialog.this.removeListener(textField);
                return super.stopCellEditing();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, final int column) {
                super.getTableCellEditorComponent(table, value, isSelected, row, column);
                AutomaticUsageRenamingDialog.this.removeListener(textField);
                AutomaticUsageRenamingDialog.this.myCellEditorListener = new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        AutomaticUsageRenamingDialog.this.myTableModel.setValueAt(this.getCellEditorValue(), row, column);
                        AutomaticUsageRenamingDialog.this.setChecked(row, true);
                        String errorText = AutomaticUsageRenamingDialog.this.myRenamer.getErrorText(AutomaticUsageRenamingDialog.this.getElements().get(row));
                        textField.setToolTipText(errorText);
                        Font font = textField.getFont();
                        if (errorText != null) {
                            textField.setForeground(SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
                            textField.setFont(font.deriveFont(font.getStyle() | 2));
                        } else {
                            textField.setForeground(SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor());
                            textField.setFont(font.deriveFont(font.getStyle() & 0xFFFFFFFD));
                        }
                        AutomaticUsageRenamingDialog.this.repaintTable();
                    }
                };
                textField.getDocument().addDocumentListener((DocumentListener)AutomaticUsageRenamingDialog.this.myCellEditorListener);
                return textField;
            }
        });
    }

    private void repaintTable() {
        this.myTable.invalidate();
        this.myTable.repaint();
    }

    private void setupOldNameColumn() {
        this.myTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Object element = value;
                this.setToolTipText(AutomaticUsageRenamingDialog.this.getErrorText(element));
                this.append(AutomaticUsageRenamingDialog.this.myRenamer.getName(element), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String sourceName = AutomaticUsageRenamingDialog.this.myRenamer.getSourceName(element);
                if (sourceName != null) {
                    this.append(" (" + sourceName + ")", AutomaticUsageRenamingDialog.makeItalic(SimpleTextAttributes.GRAYED_ATTRIBUTES));
                }
            }
        });
    }

    private void removeListener(JTextField textField) {
        if (this.myCellEditorListener != null) {
            textField.getDocument().removeDocumentListener((DocumentListener)this.myCellEditorListener);
        }
    }

    private static SimpleTextAttributes makeItalic(SimpleTextAttributes attributes) {
        return new SimpleTextAttributes(2 | attributes.getStyle(), attributes.getFgColor(), attributes.getWaveColor());
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        this.handleChanges();
        super.doOKAction();
    }

    private void updateRenamer() {
        for (int i = 0; i < this.getElementCount(); ++i) {
            T element = this.getElements().get(i);
            if (this.myShouldRename[i]) {
                this.myRenamer.setRename(element, this.myNewNames[i]);
                continue;
            }
            this.myRenamer.doNotRename(element);
        }
    }

    protected void setChecked(int rowIndex, boolean checked) {
        this.myTableModel.setValueAt(checked, rowIndex, 0);
    }

    protected String[] getNewNames() {
        return this.myNewNames;
    }

    protected void setChecked(T element, boolean checked) {
        this.setChecked(this.getElements().indexOf(element), checked);
    }

    private List<? extends T> getElements() {
        return this.myRenamer.getElements();
    }

    protected boolean isChecked(T element) {
        return this.myShouldRename[this.getElements().indexOf(element)];
    }

    private class MyTableModel
    extends AbstractTableModel {
        public MyTableModel() {
            InputMap inputMap = AutomaticUsageRenamingDialog.this.myTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
            AutomaticUsageRenamingDialog.this.myTable.getActionMap().put("enable_disable", new MySpaceAction());
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
            AutomaticUsageRenamingDialog.this.myTable.getActionMap().put("enter", new EnterAction());
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AutomaticUsageRenamingDialog.this.getElementCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AutomaticUsageRenamingDialog.this.myShouldRename[rowIndex];
                }
                case 1: {
                    return AutomaticUsageRenamingDialog.this.getElements().get(rowIndex);
                }
                case 2: {
                    return AutomaticUsageRenamingDialog.this.myNewNames[rowIndex];
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((AutomaticUsageRenamingDialog)AutomaticUsageRenamingDialog.this).myShouldRename[rowIndex] = (Boolean)aValue;
                    break;
                }
                case 2: {
                    ((AutomaticUsageRenamingDialog)AutomaticUsageRenamingDialog.this).myNewNames[rowIndex] = (String)aValue;
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
            AutomaticUsageRenamingDialog.this.handleChanges();
            AutomaticUsageRenamingDialog.this.repaintTable();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Nullable
        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return RefactoringBundle.message((String)"automatic.renamer.enity.name.column", (Object[])new Object[]{AutomaticUsageRenamingDialog.this.myRenamer.getEntityName()});
                }
                case 2: {
                    return RefactoringBundle.message((String)"automatic.renamer.rename.to.column");
                }
            }
            return " ";
        }

        private class EnterAction
        extends AbstractAction {
            private EnterAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutomaticUsageRenamingDialog.this.myTable.isEditing()) {
                    AutomaticUsageRenamingDialog.this.doOKAction();
                }
            }
        }

        private class MySpaceAction
        extends AbstractAction {
            private MySpaceAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutomaticUsageRenamingDialog.this.myTable.isEditing()) {
                    return;
                }
                int row = AutomaticUsageRenamingDialog.this.myTable.getSelectionModel().getAnchorSelectionIndex();
                if (row >= 0 && row < AutomaticUsageRenamingDialog.this.getElementCount()) {
                    ((AutomaticUsageRenamingDialog)AutomaticUsageRenamingDialog.this).myShouldRename[row] = !AutomaticUsageRenamingDialog.this.myShouldRename[row];
                    MyTableModel.this.fireTableDataChanged();
                    AutomaticUsageRenamingDialog.this.repaintTable();
                    AutomaticUsageRenamingDialog.this.myTable.requestFocus();
                }
            }
        }
    }
}

