/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameUtil");

    private RenameUtil() {
    }

    @NotNull
    public static UsageInfo[] findUsages(@NotNull PsiElement element, String newName, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        String stringToReplace;
        String stringToSearch;
        List<UsageInfo> result = Collections.synchronizedList(new ArrayList());
        PsiManager manager = element.getManager();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        Collection<PsiReference> refs = processor2.findReferences(element, searchInStringsAndComments);
        for (PsiReference ref : refs) {
            if (ref == null) {
                LOG.error("null reference from processor " + processor2);
                continue;
            }
            PsiElement referenceElement = ref.getElement();
            result.add((UsageInfo)new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0)));
        }
        processor2.findCollisions(element, newName, allRenames, result);
        PsiElement searchForInComments = processor2.getElementToSearchInStringsAndComments(element);
        if (searchInStringsAndComments && searchForInComments != null && (stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS)).length() > 0) {
            stringToReplace = RenameUtil.getStringToReplace(element, newName, false, processor2);
            NonCodeUsageInfoFactory factory = new NonCodeUsageInfoFactory(searchForInComments, stringToReplace);
            TextOccurrencesUtil.addUsagesInStringsAndComments(searchForInComments, stringToSearch, result, factory);
        }
        if (searchForTextOccurrences && searchForInComments != null) {
            Pair<String, String> additionalStringToSearch;
            stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
            if (stringToSearch.length() > 0) {
                stringToReplace = RenameUtil.getStringToReplace(element, newName, true, processor2);
                RenameUtil.addTextOccurrence(searchForInComments, result, projectScope, stringToSearch, stringToReplace);
            }
            if ((additionalStringToSearch = processor2.getTextOccurrenceSearchStrings(searchForInComments, newName)) != null && ((String)additionalStringToSearch.first).length() > 0) {
                RenameUtil.addTextOccurrence(searchForInComments, result, projectScope, (String)additionalStringToSearch.first, (String)additionalStringToSearch.second);
            }
        }
        return result.toArray(new UsageInfo[result.size()]);
    }

    private static void addTextOccurrence(final PsiElement element, List<UsageInfo> result, GlobalSearchScope projectScope, String stringToSearch, final String stringToReplace) {
        UsageInfoFactory factory = new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                TextRange textRange = usage.getTextRange();
                int start = textRange == null ? 0 : textRange.getStartOffset();
                return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)element, (String)stringToReplace);
            }
        };
        TextOccurrencesUtil.addTextOccurences(element, stringToSearch, projectScope, result, factory);
    }

    public static void buildPackagePrefixChangedMessage(VirtualFile[] virtualFiles, StringBuffer message, String qualifiedName) {
        if (virtualFiles.length > 0) {
            message.append(RefactoringBundle.message((String)"package.occurs.in.package.prefixes.of.the.following.source.folders.n", (Object[])new Object[]{qualifiedName}));
            for (VirtualFile virtualFile : virtualFiles) {
                message.append(virtualFile.getPresentableUrl()).append("\n");
            }
            message.append(RefactoringBundle.message((String)"these.package.prefixes.will.be.changed"));
        }
    }

    private static String getStringToReplace(PsiElement element, String newName, boolean nonJava, RenamePsiElementProcessor theProcessor) {
        String result;
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (element instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)element).getMetaData()) != null) {
            return metaData.getName();
        }
        if (theProcessor != null && (result = theProcessor.getQualifiedNameAfterRename(element, newName, nonJava)) != null) {
            return result;
        }
        if (element instanceof PsiNamedElement) {
            return newName;
        }
        LOG.error("Unknown element type : " + element);
        return null;
    }

    public static void checkRename(PsiElement element, String newName) throws IncorrectOperationException {
        if (element instanceof PsiCheckedRenameElement) {
            ((PsiCheckedRenameElement)element).checkSetName(newName);
        }
    }

    public static void doRename(final PsiElement element, String newName, UsageInfo[] usages, Project project2, final @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        String fqn;
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        String string = fqn = element instanceof PsiFile ? ((PsiFile)element).getVirtualFile().getPath() : CopyReferenceAction.elementToFqn(element);
        if (fqn != null) {
            BasicUndoableAction action = new BasicUndoableAction(){

                public void undo() throws UnexpectedUndoException {
                    if (listener2 instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)listener2).undoElementMovedOrRenamed(element, fqn);
                    }
                }

                public void redo() throws UnexpectedUndoException {
                }
            };
            UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)action);
        }
        processor2.renameElement(element, newName, usages, listener2);
    }

    public static void showErrorMessage(final IncorrectOperationException e, final PsiElement element, final Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String helpID = RenamePsiElementProcessor.forElement(element).getHelpID(element);
                String message = e.getMessage();
                if (StringUtil.isEmpty((String)message)) {
                    message = RefactoringBundle.message((String)"rename.not.supported");
                }
                CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)message, (String)helpID, (Project)project2);
            }
        });
    }

    public static void doRenameGenericNamedElement(@NotNull PsiElement namedElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        PsiMetaData metaData;
        PsiWritableMetaData writableMetaData = null;
        if (namedElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)namedElement).getMetaData()) instanceof PsiWritableMetaData) {
            writableMetaData = (PsiWritableMetaData)metaData;
        }
        if (writableMetaData == null && !(namedElement instanceof PsiNamedElement)) {
            LOG.error("Unknown element type:" + namedElement);
        }
        boolean hasBindables = false;
        for (UsageInfo usage : usages) {
            if (!(usage.getReference() instanceof BindablePsiReference)) {
                RenameUtil.rename(usage, newName);
                continue;
            }
            hasBindables = true;
        }
        if (writableMetaData != null) {
            writableMetaData.setName(newName);
        } else {
            PsiElement namedElementAfterRename = ((PsiNamedElement)namedElement).setName(newName);
            if (namedElementAfterRename != null) {
                namedElement = namedElementAfterRename;
            }
        }
        if (hasBindables) {
            for (UsageInfo usage : usages) {
                PsiReference ref = usage.getReference();
                if (!(ref instanceof BindablePsiReference)) continue;
                boolean fallback = true;
                if (!(ref instanceof FragmentaryPsiReference) || !((FragmentaryPsiReference)ref).isFragmentOnlyRename()) {
                    try {
                        ref.bindToElement(namedElement);
                        fallback = false;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                }
                if (!fallback) continue;
                ref.handleElementRename(newName);
            }
        }
        if (listener2 != null) {
            listener2.elementRenamed(namedElement);
        }
    }

    public static void rename(UsageInfo info, String newName) throws IncorrectOperationException {
        if (info.getElement() == null) {
            return;
        }
        PsiReference ref = info.getReference();
        if (ref == null) {
            return;
        }
        ref.handleElementRename(newName);
    }

    @Nullable
    public static List<UnresolvableCollisionUsageInfo> removeConflictUsages(Set<UsageInfo> usages) {
        ArrayList<UnresolvableCollisionUsageInfo> result = new ArrayList<UnresolvableCollisionUsageInfo>();
        Iterator<UsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
            result.add((UnresolvableCollisionUsageInfo)usageInfo);
            iterator.remove();
        }
        return result.isEmpty() ? null : result;
    }

    public static void addConflictDescriptions(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof UnresolvableCollisionUsageInfo)) continue;
            conflicts.putValue((Object)usage.getElement(), (Object)((UnresolvableCollisionUsageInfo)usage).getDescription());
        }
    }

    public static void renameNonCodeUsages(@NotNull Project project2, @NotNull NonCodeUsageInfo[] usages) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        HashMap docsToOffsetsMap = new HashMap();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        for (NonCodeUsageInfo usage : usages) {
            ProperTextRange rangeInElement;
            PsiElement element = usage.getElement();
            if (element == null || (element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, true)) == null || (rangeInElement = usage.getRangeInElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            Document document = psiDocumentManager.getDocument(containingFile);
            Segment segment = usage.getSegment();
            LOG.assertTrue(segment != null);
            int fileOffset = segment.getStartOffset();
            ArrayList<UsageOffset> list = (ArrayList<UsageOffset>)docsToOffsetsMap.get(document);
            if (list == null) {
                list = new ArrayList<UsageOffset>();
                docsToOffsetsMap.put(document, list);
            }
            list.add(new UsageOffset(fileOffset, fileOffset + rangeInElement.getLength(), usage.newText));
        }
        for (Document document : docsToOffsetsMap.keySet()) {
            List list = (List)docsToOffsetsMap.get(document);
            LOG.assertTrue(list != null, (Object)document);
            Object[] offsets = list.toArray(new UsageOffset[list.size()]);
            Arrays.sort(offsets);
            for (int i = offsets.length - 1; i >= 0; --i) {
                Object usageOffset = offsets[i];
                document.replaceString(((UsageOffset)usageOffset).startOffset, ((UsageOffset)usageOffset).endOffset, (CharSequence)((UsageOffset)usageOffset).newText);
            }
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
    }

    public static boolean isValidName(Project project2, PsiElement psiElement, String newName) {
        Language fileLanguage;
        if (newName == null || newName.length() == 0) {
            return false;
        }
        Condition inputValidator = RenameInputValidatorRegistry.getInputValidator((PsiElement)psiElement);
        if (inputValidator != null) {
            return inputValidator.value((Object)newName);
        }
        if (psiElement instanceof PsiFile || psiElement instanceof PsiDirectory) {
            return newName.indexOf(92) < 0 && newName.indexOf(47) < 0;
        }
        if (psiElement instanceof PomTargetPsiElement) {
            return !StringUtil.isEmptyOrSpaces((String)newName);
        }
        PsiFile file2 = psiElement.getContainingFile();
        Language elementLanguage = psiElement.getLanguage();
        Language language = fileLanguage = file2 == null ? null : file2.getLanguage();
        Language language2 = fileLanguage == null ? elementLanguage : (fileLanguage.isKindOf(elementLanguage) ? fileLanguage : elementLanguage);
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language2)).isIdentifier(newName.trim(), project2);
    }

    private static class UsageOffset
    implements Comparable<UsageOffset> {
        final int startOffset;
        final int endOffset;
        final String newText;

        public UsageOffset(int startOffset, int endOffset, String newText) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.newText = newText;
        }

        @Override
        public int compareTo(UsageOffset o) {
            return this.startOffset - o.startOffset;
        }
    }
}

