/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenameAliasingPomTargetProcessor
extends RenamePsiElementProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PomTarget || element instanceof PomTargetPsiElement;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PomTarget target = null;
        if (element instanceof PomTargetPsiElement) {
            target = ((PomTargetPsiElement)element).getTarget();
        } else if (element instanceof PomTarget) {
            target = (PomTarget)element;
        }
        if (target != null) {
            for (AliasingPsiTargetMapper mapper : (AliasingPsiTargetMapper[])Extensions.getExtensions((ExtensionPointName)AliasingPsiTargetMapper.EP_NAME)) {
                for (AliasingPsiTarget psiTarget : mapper.getTargets(target)) {
                    String name;
                    PsiElement psiElement = PomService.convertToPsi((PsiTarget)psiTarget);
                    String definedName = allRenames.put(psiElement, name = psiTarget.getNameAlias(newName));
                    if (definedName != null) {
                        assert (definedName.equals(name));
                        continue;
                    }
                    this.prepareRenaming(psiElement, name, allRenames);
                }
            }
        }
    }
}

