/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.removemiddleman.DelegationUtils;
import com.intellij.refactoring.removemiddleman.RemoveMiddlemanDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoveMiddlemanHandler
implements RefactoringActionHandler {
    private static final String REFACTORING_NAME = RefactorJBundle.message("remove.middleman", new Object[0]);
    @NonNls
    static final String REMOVE_METHODS = "refactoring.removemiddleman.remove.methods";

    protected static String getRefactoringName() {
        return REFACTORING_NAME;
    }

    protected static String getHelpID() {
        return "refactorj.removeMiddleman";
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (!(element instanceof PsiField)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.caret.should.be.positioned.at.the.name.of.the.field.to.be.refactored", new Object[0])), null, (String)RemoveMiddlemanHandler.getHelpID());
            return;
        }
        RemoveMiddlemanHandler.invoke((PsiField)element, editor);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        if (elements[0] instanceof PsiField) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            RemoveMiddlemanHandler.invoke((PsiField)elements[0], editor);
        }
    }

    private static void invoke(PsiField field, Editor editor) {
        Project project2 = field.getProject();
        Set<PsiMethod> delegating = DelegationUtils.getDelegatingMethodsForField(field);
        if (delegating.isEmpty()) {
            String message = RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("field.selected.is.not.used.as.a.delegate", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, null, (String)RemoveMiddlemanHandler.getHelpID());
            return;
        }
        MemberInfo[] infos = new MemberInfo[delegating.size()];
        int i = 0;
        for (PsiMethod method : delegating) {
            MemberInfo memberInfo = new MemberInfo((PsiMember)method);
            memberInfo.setChecked(true);
            memberInfo.setToAbstract(method.findDeepestSuperMethods().length == 0);
            infos[i++] = memberInfo;
        }
        new RemoveMiddlemanDialog(field, infos).show();
    }
}

