/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.removemiddleman.RemoveMiddlemanProcessor;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class RemoveMiddlemanDialog
extends RefactoringDialog {
    private final JTextField fieldNameLabel;
    private final List<MemberInfo> delegateMethods;
    private final PsiField myField;

    RemoveMiddlemanDialog(PsiField field, MemberInfo[] delegateMethods) {
        super(field.getProject(), true);
        this.myField = field;
        this.delegateMethods = Arrays.asList(delegateMethods);
        this.fieldNameLabel = new JTextField();
        this.fieldNameLabel.setText(PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY));
        this.setTitle(RefactorJBundle.message("remove.middleman.title", new Object[0]));
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.RemoveMiddleman";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        MemberSelectionPanel selectionPanel = new MemberSelectionPanel("&Methods to inline", this.delegateMethods, "Delete");
        MemberSelectionTable table = selectionPanel.getTable();
        table.setMemberInfoModel(new DelegatingMemberInfoModel<PsiMember, MemberInfo>(table.getMemberInfoModel()){

            @Override
            public int checkForProblems(@NotNull MemberInfo member) {
                return this.hasSuperMethods(member) ? 2 : 0;
            }

            @Override
            public String getTooltipText(MemberInfo member) {
                if (this.hasSuperMethods(member)) {
                    return "Deletion will break type hierarchy";
                }
                return super.getTooltipText(member);
            }

            private boolean hasSuperMethods(MemberInfo member) {
                PsiMember psiMember;
                return member.isChecked() && member.isToAbstract() && (psiMember = (PsiMember)member.getMember()) instanceof PsiMethod && ((PsiMethod)psiMember).findDeepestSuperMethods().length > 0;
            }
        });
        panel.add((Component)selectionPanel, "Center");
        return panel;
    }

    protected JComponent createNorthPanel() {
        this.fieldNameLabel.setEditable(false);
        JPanel sourceClassPanel = new JPanel(new BorderLayout());
        sourceClassPanel.add((Component)new JLabel("Delegating field"), "North");
        sourceClassPanel.add((Component)this.fieldNameLabel, "Center");
        return sourceClassPanel;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactorj.removeMiddleman");
    }

    @Override
    protected void doAction() {
        this.invokeRefactoring(new RemoveMiddlemanProcessor(this.myField, this.delegateMethods));
    }
}

