/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.move.moveInner.MoveInnerClassUsagesHandler;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

public class MoveInnerClassJavaUsagesHandler
implements MoveInnerClassUsagesHandler {
    @Override
    public void correctInnerClassUsage(@NotNull UsageInfo usage, @NotNull PsiClass outerClass) {
        PsiNewExpression newExpr;
        PsiExpressionList argList;
        PsiElement refElement = usage.getElement();
        if (refElement == null) {
            return;
        }
        PsiManager manager = refElement.getManager();
        PsiElement refParent = refElement.getParent();
        if ((refParent instanceof PsiNewExpression || refParent instanceof PsiAnonymousClass) && (argList = (newExpr = refParent instanceof PsiNewExpression ? (PsiNewExpression)refParent : (PsiNewExpression)refParent.getParent()).getArgumentList()) != null) {
            if (newExpr.getQualifier() == null) {
                PsiClass parentClass = RefactoringChangeUtil.getThisClass((PsiElement)newExpr);
                PsiThisExpression thisExpr = outerClass.equals(parentClass) ? RefactoringChangeUtil.createThisExpression(manager, null) : RefactoringChangeUtil.createThisExpression(manager, outerClass);
                argList.addAfter((PsiElement)thisExpr, null);
            } else {
                argList.addAfter((PsiElement)newExpr.getQualifier(), null);
                newExpr.getQualifier().delete();
            }
        }
    }
}

