/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaMoveClassToInnerHandler
implements MoveClassToInnerHandler {
    private static final Logger LOG = Logger.getInstance(JavaMoveClassToInnerHandler.class);

    @Override
    public PsiClass moveClass(@NotNull PsiClass aClass, @NotNull PsiClass targetClass) {
        if (aClass.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)aClass, true);
        PsiClass newClass = (PsiClass)targetClass.addBefore((PsiElement)aClass, targetClass.getRBrace());
        if (targetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"packageLocal", (boolean)true);
        } else {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newClass, (String)"static", (boolean)true);
        }
        return (PsiClass)ChangeContextUtil.decodeContextInfo((PsiElement)newClass, null, null);
    }

    @Override
    public List<PsiElement> filterImports(@NotNull List<UsageInfo> usageInfos, @NotNull Project project2) {
        ArrayList<PsiElement> importStatements = new ArrayList<PsiElement>();
        if (!CodeStyleSettingsManager.getSettings((Project)project2).INSERT_INNER_CLASS_IMPORTS) {
            JavaMoveClassToInnerHandler.filterUsagesInImportStatements(usageInfos, importStatements);
        } else {
            Collections.sort(usageInfos, new Comparator<UsageInfo>(){

                @Override
                public int compare(UsageInfo o1, UsageInfo o2) {
                    return PsiUtil.BY_POSITION.compare(o1.getElement(), o2.getElement());
                }
            });
        }
        return importStatements;
    }

    private static void filterUsagesInImportStatements(List<UsageInfo> usages, List<PsiElement> importStatements) {
        Iterator<UsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            PsiImportStatement stmt;
            UsageInfo usage = iterator.next();
            PsiElement element = usage.getElement();
            if (element == null || (stmt = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class)) == null) continue;
            importStatements.add((PsiElement)stmt);
            iterator.remove();
        }
    }

    @Override
    public void retargetClassRefsInMoved(final @NotNull Map<PsiElement, PsiElement> oldToNewElementsMapping) {
        for (PsiElement newClass : oldToNewElementsMapping.values()) {
            if (newClass.getLanguage() != JavaLanguage.INSTANCE) continue;
            newClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiElement element = reference.resolve();
                    if (element instanceof PsiClass) {
                        for (PsiElement oldClass : oldToNewElementsMapping.keySet()) {
                            if (!PsiTreeUtil.isAncestor((PsiElement)oldClass, (PsiElement)element, (boolean)false)) continue;
                            PsiClass newInnerClass = JavaMoveClassToInnerHandler.findMatchingClass((PsiClass)oldClass, (PsiClass)oldToNewElementsMapping.get(oldClass), (PsiClass)element);
                            try {
                                reference.bindToElement((PsiElement)newInnerClass);
                                return;
                            }
                            catch (IncorrectOperationException ex) {
                                LOG.error((Throwable)ex);
                            }
                        }
                    }
                    super.visitReferenceElement(reference);
                }
            });
        }
    }

    private static PsiClass findMatchingClass(PsiClass classToMove, PsiClass newClass, PsiClass innerClass) {
        if (classToMove == innerClass) {
            return newClass;
        }
        PsiClass parentClass = JavaMoveClassToInnerHandler.findMatchingClass(classToMove, newClass, innerClass.getContainingClass());
        PsiClass newInnerClass = parentClass.findInnerClassByName(innerClass.getName(), false);
        assert (newInnerClass != null);
        return newInnerClass;
    }

    @Override
    public void retargetNonCodeUsages(@NotNull Map<PsiElement, PsiElement> oldToNewElementMap, final @NotNull NonCodeUsageInfo[] nonCodeUsages) {
        for (PsiElement newClass : oldToNewElementMap.values()) {
            if (newClass.getLanguage() != JavaLanguage.INSTANCE) continue;
            newClass.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    List list = (List)element.getCopyableUserData(MoveClassToInnerProcessor.ourNonCodeUsageKey);
                    if (list != null) {
                        block0: for (NonCodeUsageInfo info : list) {
                            for (int i = 0; i < nonCodeUsages.length; ++i) {
                                if (nonCodeUsages[i] != info) continue;
                                nonCodeUsages[i] = info.replaceElement(element);
                                continue block0;
                            }
                        }
                        element.putCopyableUserData(MoveClassToInnerProcessor.ourNonCodeUsageKey, null);
                    }
                }
            });
        }
    }

    @Override
    public void removeRedundantImports(PsiFile targetClassFile) {
        if (targetClassFile instanceof PsiJavaFile) {
            JavaCodeStyleManager.getInstance((Project)targetClassFile.getProject()).removeRedundantImports((PsiJavaFile)targetClassFile);
        }
    }
}

