/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectProcessor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Set;

public class AppendAccessorsUsageInfo
extends FixableUsageInfo {
    private final boolean myGenerateAccessors;
    private final Set<PsiParameter> paramsNeedingSetters;
    private final Set<PsiParameter> paramsNeedingGetters;
    private final List<IntroduceParameterObjectProcessor.ParameterChunk> parameters;
    private static final Logger LOGGER = Logger.getInstance((String)("#" + AppendAccessorsUsageInfo.class.getName()));

    public AppendAccessorsUsageInfo(PsiElement psiClass, boolean generateAccessors, Set<PsiParameter> paramsNeedingGetters, Set<PsiParameter> paramsNeedingSetters, List<IntroduceParameterObjectProcessor.ParameterChunk> parameters) {
        super(psiClass);
        this.myGenerateAccessors = generateAccessors;
        this.paramsNeedingGetters = paramsNeedingGetters;
        this.paramsNeedingSetters = paramsNeedingSetters;
        this.parameters = parameters;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        if (this.myGenerateAccessors) {
            this.appendAccessors(this.paramsNeedingGetters, true);
            this.appendAccessors(this.paramsNeedingSetters, false);
        }
    }

    private void appendAccessors(Set<PsiParameter> params, boolean isGetter) {
        PsiElement element = this.getElement();
        if (element != null) {
            for (PsiParameter parameter : params) {
                IntroduceParameterObjectProcessor.ParameterChunk parameterChunk = IntroduceParameterObjectProcessor.ParameterChunk.getChunkByParameter(parameter, this.parameters);
                LOGGER.assertTrue(parameterChunk != null);
                PsiField field = parameterChunk.getField();
                if (field == null) continue;
                element.add((PsiElement)(isGetter ? GenerateMembersUtil.generateGetterPrototype(field) : GenerateMembersUtil.generateSetterPrototype(field)));
            }
        }
    }

    @Override
    public String getConflictMessage() {
        if (!(this.myGenerateAccessors || this.paramsNeedingSetters.isEmpty() && this.paramsNeedingGetters.isEmpty())) {
            StringBuffer buf = new StringBuffer();
            this.appendConflicts(buf, this.paramsNeedingGetters);
            this.appendConflicts(buf, this.paramsNeedingSetters);
            return RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + buf.toString();
        }
        return null;
    }

    private void appendConflicts(StringBuffer buf, Set<PsiParameter> paramsNeeding) {
        if (!paramsNeeding.isEmpty()) {
            buf.append(paramsNeeding == this.paramsNeedingGetters ? "Getters" : "Setters");
            buf.append(" for the following fields are required:\n");
            buf.append(StringUtil.join(paramsNeeding, (Function)new Function<PsiParameter, String>(){

                public String fun(PsiParameter psiParameter) {
                    PsiField field;
                    IntroduceParameterObjectProcessor.ParameterChunk chunk = IntroduceParameterObjectProcessor.ParameterChunk.getChunkByParameter(psiParameter, AppendAccessorsUsageInfo.this.parameters);
                    if (chunk != null && (field = chunk.getField()) != null) {
                        return field.getName();
                    }
                    return psiParameter.getName();
                }
            }, (String)", "));
            buf.append(".\n");
        }
    }
}

