/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.ClassMemberInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.LocalVariableInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.ParameterInExprUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static void analyzeExpression(PsiExpression expr, List<UsageInfo> localVars, List<UsageInfo> classMemberRefs, List<UsageInfo> params) {
        PsiElement[] children2;
        if (expr instanceof PsiThisExpression || expr instanceof PsiSuperExpression) {
            classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)expr));
        } else if (expr instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
            PsiElement subj = refExpr.resolve();
            if (subj instanceof PsiParameter) {
                params.add(new ParameterInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiLocalVariable) {
                localVars.add(new LocalVariableInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiField || subj instanceof PsiMethod) {
                classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)refExpr));
            }
        }
        for (PsiElement child : children2 = expr.getChildren()) {
            if (!(child instanceof PsiExpression)) continue;
            Util.analyzeExpression((PsiExpression)child, localVars, classMemberRefs, params);
        }
    }

    @NotNull
    private static PsiElement getPhysical(@NotNull PsiElement expr) {
        PsiElement physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT);
        if (physicalElement != null) {
            expr = physicalElement;
        }
        return expr;
    }

    public static PsiMethod getContainingMethod(PsiElement expr) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)Util.getPhysical(expr), PsiMethod.class);
    }

    public static boolean isAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        return PsiTreeUtil.isAncestor((PsiElement)Util.getPhysical(ancestor), (PsiElement)Util.getPhysical(element), (boolean)strict);
    }

    public static boolean anyFieldsWithGettersPresent(List<UsageInfo> classMemberRefs) {
        for (UsageInfo usageInfo : classMemberRefs) {
            PsiElement e;
            if (!(usageInfo.getElement() instanceof PsiReferenceExpression) || !((e = ((PsiReferenceExpression)usageInfo.getElement()).resolve()) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)e;
            PsiMethod getterPrototype = GenerateMembersUtil.generateGetterPrototype(psiField);
            PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
            if (getter == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TIntArrayList findParametersToRemove(@NotNull PsiMethod method, final @NotNull PsiExpression expr, final @Nullable PsiExpression[] occurences) {
        final PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return new TIntArrayList();
        }
        Object[] overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        PsiMethod[] allMethods = (PsiMethod[])ArrayUtil.append((Object[])overridingMethods, (Object)method);
        final TIntHashSet suspects = new TIntHashSet();
        expr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                int i;
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiParameter && (i = ArrayUtil.find((Object[])parameters, (Object)resolved)) != -1) {
                    suspects.add(i);
                }
            }
        });
        final TIntIterator iterator = suspects.iterator();
        while (iterator.hasNext()) {
            PsiParameter parameter;
            PsiMethod psiMethod;
            PsiParameter[] psiParameters;
            int paramNum = iterator.next();
            PsiMethod[] psiMethodArray = allMethods;
            int n = psiMethodArray.length;
            for (int i = 0; i < n && (paramNum >= (psiParameters = (psiMethod = psiMethodArray[i]).getParameterList().getParameters()).length || ReferencesSearch.search((PsiElement)(parameter = psiParameters[paramNum]), (SearchScope)parameter.getResolveScope(), (boolean)false).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    boolean stillCanBeRemoved = false;
                    if (element != null) {
                        boolean bl = stillCanBeRemoved = Util.isAncestor((PsiElement)expr, element, false) || PsiUtil.isInsideJavadocComment((PsiElement)Util.getPhysical(element));
                        if (!stillCanBeRemoved && occurences != null) {
                            for (PsiExpression occurence : occurences) {
                                if (!Util.isAncestor((PsiElement)occurence, element, false)) continue;
                                stillCanBeRemoved = true;
                                break;
                            }
                        }
                    }
                    if (!stillCanBeRemoved) {
                        iterator.remove();
                        return false;
                    }
                    return true;
                }
            })); ++i) {
            }
        }
        return new TIntArrayList(suspects.toArray());
    }
}

