/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineConstantFieldProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inline.InlineConstantFieldProcessor");
    private PsiField myField;
    private final PsiReferenceExpression myRefExpr;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInCommentsAndStrings;
    private final boolean mySearchForTextOccurrences;

    public InlineConstantFieldProcessor(PsiField field, Project project2, PsiReferenceExpression ref, boolean isInlineThisOnly) {
        this(field, project2, ref, isInlineThisOnly, false, false);
    }

    public InlineConstantFieldProcessor(PsiField field, Project project2, PsiReferenceExpression ref, boolean isInlineThisOnly, boolean searchInCommentsAndStrings, boolean searchForTextOccurrences) {
        super(project2);
        this.myField = field;
        this.myRefExpr = ref;
        this.myInlineThisOnly = isInlineThisOnly;
        this.mySearchInCommentsAndStrings = searchInCommentsAndStrings;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new InlineViewDescriptor((PsiElement)this.myField);
    }

    @Override
    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo info : usages) {
            if (!(info instanceof NonCodeUsageInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myInlineThisOnly) {
            return new UsageInfo[]{new UsageInfo((PsiQualifiedReferenceElement)this.myRefExpr)};
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false)) {
            PsiElement element = ref.getElement();
            UsageInfo info = new UsageInfo(element);
            if (!(element instanceof PsiExpression) && PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) == null) {
                info = new UsageFromJavaDoc(element);
            }
            usages.add(info);
        }
        if (this.mySearchInCommentsAndStrings || this.mySearchForTextOccurrences) {
            String stringToSearch;
            NonCodeUsageInfoFactory nonCodeUsageFactory = new NonCodeUsageInfoFactory((PsiElement)this.myField, this.myField.getName()){

                @Override
                public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                    if (PsiTreeUtil.isAncestor((PsiElement)InlineConstantFieldProcessor.this.myField, (PsiElement)usage, (boolean)false)) {
                        return null;
                    }
                    return super.createUsageInfo(usage, startOffset, endOffset);
                }
            };
            if (this.mySearchInCommentsAndStrings) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myField, stringToSearch, usages, nonCodeUsageFactory);
            }
            if (this.mySearchForTextOccurrences) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
                TextOccurrencesUtil.addTextOccurences((PsiElement)this.myField, stringToSearch, GlobalSearchScope.projectScope((Project)this.myProject), usages, nonCodeUsageFactory);
            }
        }
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof PsiField);
        this.myField = (PsiField)elements[0];
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiExpression initializer = this.myField.getInitializer();
        LOG.assertTrue(initializer != null);
        initializer = InlineConstantFieldProcessor.normalize((PsiExpression)initializer.copy());
        for (UsageInfo info : usages) {
            PsiElement element;
            if (info instanceof UsageFromJavaDoc || info instanceof NonCodeUsageInfo || (element = info.getElement()) == null) continue;
            try {
                if (element instanceof PsiExpression) {
                    this.inlineExpressionUsage((PsiExpression)element, initializer);
                    continue;
                }
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                LOG.assertTrue(importStaticStatement != null, (Object)element.getText());
                importStaticStatement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly) {
            try {
                this.myField.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myField);
        return data;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.field";
    }

    private void inlineExpressionUsage(PsiExpression expr, PsiExpression initializer1) throws IncorrectOperationException {
        PsiExpression qExpression;
        if (this.myField.isWritable()) {
            this.myField.normalizeDeclaration();
        }
        if (expr instanceof PsiReferenceExpression && (qExpression = ((PsiReferenceExpression)expr).getQualifierExpression()) != null) {
            PsiReferenceExpression referenceExpression = null;
            if (initializer1 instanceof PsiReferenceExpression) {
                referenceExpression = (PsiReferenceExpression)initializer1;
            } else if (initializer1 instanceof PsiMethodCallExpression) {
                referenceExpression = ((PsiMethodCallExpression)initializer1).getMethodExpression();
            }
            if (referenceExpression != null && referenceExpression.getQualifierExpression() == null && !(referenceExpression.advancedResolve(false).getCurrentFileResolveScope() instanceof PsiImportStaticStatement)) {
                referenceExpression.setQualifierExpression(qExpression);
            }
        }
        InlineUtil.inlineVariable((PsiVariable)this.myField, initializer1, (PsiJavaCodeReferenceElement)expr);
    }

    private static PsiExpression normalize(PsiExpression expression) {
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
            try {
                PsiType type = expression.getType();
                if (type != null) {
                    String typeString = type.getCanonicalText();
                    PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + typeString + "{}", (PsiElement)expression);
                    result.getArrayInitializer().replace((PsiElement)expression);
                    return result;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return expression;
            }
        }
        return expression;
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.field.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myField)});
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiElement element;
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        PsiExpression initializer = this.myField.getInitializer();
        LOG.assertTrue(initializer != null);
        initializer.accept((PsiElementVisitor)collector);
        HashSet<PsiMember> referencedWithVisibility = collector.myReferencedMembers;
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myField.getProject()).getResolveHelper();
        for (UsageInfo info : usagesIn) {
            element = info.getElement();
            if (element instanceof PsiExpression && InlineConstantFieldProcessor.isAccessedForWriting((PsiExpression)element)) {
                String message = RefactoringBundle.message((String)"0.is.used.for.writing.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myField, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflicts.putValue((Object)element, (Object)message);
            }
            for (PsiMember member : referencedWithVisibility) {
                if (resolveHelper.isAccessible(member, element, null)) continue;
                String message = RefactoringBundle.message((String)"0.will.not.be.accessible.from.1.after.inlining", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, true), RefactoringUIUtil.getDescription(ConflictsUtil.getContainer(element), true)});
                conflicts.putValue((Object)member, (Object)message);
            }
        }
        if (!this.myInlineThisOnly) {
            for (UsageInfo info : usagesIn) {
                if (!(info instanceof UsageFromJavaDoc) || !((element = info.getElement()) instanceof PsiDocMethodOrFieldRef) || PsiTreeUtil.isAncestor((PsiElement)this.myField, (PsiElement)element, (boolean)false)) continue;
                conflicts.putValue((Object)element, (Object)"Inlined method is used in javadoc");
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usagesIn);
    }

    private static boolean isAccessedForWriting(PsiExpression expr) {
        while (expr.getParent() instanceof PsiArrayAccessExpression) {
            expr = (PsiExpression)expr.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr);
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (this.myInlineThisOnly) {
            return Collections.singletonList(this.myRefExpr);
        }
        return super.getElementsToWrite(descriptor);
    }

    private static class UsageFromJavaDoc
    extends UsageInfo {
        private UsageFromJavaDoc(@NotNull PsiElement element) {
            super(element, true);
        }
    }
}

