/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.BindToOldUsageInfo;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassViewDescriptor;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessorBase;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class ExtractSuperBaseProcessor
extends TurnRefsToSuperProcessorBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.extractSuperclass.ExtractSuperClassProcessor");
    protected PsiDirectory myTargetDirectory;
    protected final String myNewClassName;
    protected final MemberInfo[] myMemberInfos;
    protected final DocCommentPolicy myJavaDocPolicy;

    public ExtractSuperBaseProcessor(Project project2, boolean replaceInstanceOf, PsiDirectory targetDirectory, String newClassName, PsiClass aClass, MemberInfo[] memberInfos, DocCommentPolicy javaDocPolicy) {
        super(project2, replaceInstanceOf, newClassName);
        this.myTargetDirectory = targetDirectory;
        this.myNewClassName = newClassName;
        this.myClass = aClass;
        this.myMemberInfos = memberInfos;
        this.myJavaDocPolicy = javaDocPolicy;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new ExtractSuperClassViewDescriptor(this.myTargetDirectory, this.myClass, this.myMemberInfos);
    }

    protected boolean doesAnyExtractedInterfaceExtends(PsiClass aClass) {
        for (MemberInfo memberInfo : this.myMemberInfos) {
            PsiElement member = memberInfo.getMember();
            if (!(member instanceof PsiClass) || memberInfo.getOverrides() == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)member), (PsiClass)aClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    protected boolean doMemberInfosContain(PsiMethod method) {
        for (MemberInfo info : this.myMemberInfos) {
            PsiMethod methodBySignature;
            if (!(info.getMember() instanceof PsiMethod ? MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)((PsiMethod)info.getMember())) : info.getMember() instanceof PsiClass && info.getOverrides() != null && (methodBySignature = ((PsiClass)info.getMember()).findMethodBySignature(method, true)) != null)) continue;
            return true;
        }
        return false;
    }

    protected boolean doMemberInfosContain(PsiField field) {
        for (MemberInfo info : this.myMemberInfos) {
            if (!this.myManager.areElementsEquivalent((PsiElement)field, info.getMember())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)false).toArray((Object[])new PsiReference[0]);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        this.detectTurnToSuperRefs(refs, result);
        PsiPackage originalPackage = JavaDirectoryService.getInstance().getPackage(this.myClass.getContainingFile().getContainingDirectory());
        if (Comparing.equal((Object)JavaDirectoryService.getInstance().getPackage(this.myTargetDirectory), (Object)originalPackage)) {
            result.clear();
        }
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            if (this.canTurnToSuper(element) || RefactoringUtil.inImportStatement(ref, element)) continue;
            result.add((UsageInfo)new BindToOldUsageInfo(element, ref, this.myClass));
        }
        UsageInfo[] usageInfos = result.toArray(new UsageInfo[result.size()]);
        return UsageViewUtil.removeDuplicatedUsages(usageInfos);
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        try {
            String superClassName = this.myClass.getName();
            String oldQualifiedName = this.myClass.getQualifiedName();
            this.myClass.setName(this.myNewClassName);
            PsiClass superClass = this.extractSuper(superClassName);
            PsiDirectory initialDirectory = this.myClass.getContainingFile().getContainingDirectory();
            PsiFile containingFile = this.myClass.getContainingFile();
            try {
                if (this.myTargetDirectory != initialDirectory) {
                    containingFile = (PsiFile)this.myTargetDirectory.add(this.myClass.getContainingFile().copy());
                    this.myClass.getContainingFile().delete();
                }
            }
            catch (IncorrectOperationException e) {
                RefactoringUIUtil.processIncorrectOperation(this.myProject, e);
            }
            for (UsageInfo usage : usages) {
                PsiReference reference;
                if (!(usage instanceof BindToOldUsageInfo) || (reference = usage.getReference()) == null || !reference.getElement().isValid()) continue;
                reference.bindToElement((PsiElement)this.myClass);
            }
            if (!Comparing.equal((String)oldQualifiedName, (String)superClass.getQualifiedName())) {
                ExtractSuperBaseProcessor.processTurnToSuperRefs(usages, superClass);
            }
            if (containingFile instanceof PsiJavaFile) {
                JavaCodeStyleManager.getInstance((Project)this.myProject).removeRedundantImports((PsiJavaFile)containingFile);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.performVariablesRenaming();
    }

    protected abstract PsiClass extractSuper(String var1) throws IncorrectOperationException;

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        this.myClass = (PsiClass)elements[0];
        this.myTargetDirectory = (PsiDirectory)elements[1];
        for (int i = 0; i < this.myMemberInfos.length; ++i) {
            MemberInfo info = this.myMemberInfos[i];
            info.updateMember((PsiElement)((PsiMember)elements[i + 2]));
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"extract.subclass.command");
    }

    @Override
    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        return ((ExtractSuperClassViewDescriptor)descriptor).getMembersToMakeWritable();
    }
}

