/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureGestureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.changeSignature.RenameChangeInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeSignatureDetectorAction
extends BaseRefactoringIntentionAction {
    public static final String CHANGE_SIGNATURE = "Apply signature change";
    public static final String NEW_NAME = "Apply new name";
    private String myAcceptText;

    @NotNull
    public String getText() {
        String text = this.myAcceptText;
        return text != null ? text : CHANGE_SIGNATURE;
    }

    @NotNull
    public String getFamilyName() {
        return CHANGE_SIGNATURE;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        this.myAcceptText = null;
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        if (detector != null) {
            ChangeSignatureGestureDetector signatureGestureDetector = ChangeSignatureGestureDetector.getInstance(project2);
            PsiFile containingFile = element.getContainingFile();
            ChangeInfo changeInfo = signatureGestureDetector.getChangeInfo(containingFile);
            ChangeInfo initialChangeInfo = signatureGestureDetector.getInitialChangeInfo(containingFile);
            if (changeInfo != null && detector.isChangeSignatureAvailableOnElement(element, initialChangeInfo)) {
                this.myAcceptText = changeInfo instanceof RenameChangeInfo ? NEW_NAME : CHANGE_SIGNATURE;
            }
        }
        return this.myAcceptText != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ChangeSignatureGestureDetector.getInstance(project2).changeSignature(element.getContainingFile(), true);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

