/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.codeInsight.daemon.impl.quickfix.ChangeClassSignatureFromUsageFix;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureProcessor;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.refactoring.ui.CodeFragmentTableCellRenderer;
import com.intellij.refactoring.ui.JavaCodeFragmentTableCellEditor;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TableColumnAnimator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeClassSignatureDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(ChangeClassSignatureDialog.class);
    private static final int NAME_COLUMN = 0;
    private static final int BOUND_VALUE_COLUMN = 1;
    private static final int DEFAULT_VALUE_COLUMN = 2;
    private final List<TypeParameterInfo> myTypeParameterInfos;
    private final List<PsiTypeCodeFragment> myBoundValueTypeCodeFragments;
    private final List<PsiTypeCodeFragment> myDefaultValueTypeCodeFragments;
    private final PsiClass myClass;
    private final PsiTypeParameter[] myOriginalParameters;
    private final Project myProject;
    private final MyTableModel myTableModel;
    private JBTable myTable;
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeClassSignature.refactoring.name");
    private final boolean myHideDefaultValueColumn;

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, boolean hideDefaultValueColumn) {
        this(aClass, ChangeClassSignatureDialog.initTypeParameterInfos(aClass.getTypeParameters().length), hideDefaultValueColumn);
    }

    @NotNull
    private static List<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> initTypeParameterInfos(int length) {
        ArrayList<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> result = new ArrayList<ChangeClassSignatureFromUsageFix.TypeParameterInfoView>();
        for (int i = 0; i < length; ++i) {
            result.add(new ChangeClassSignatureFromUsageFix.TypeParameterInfoView(new TypeParameterInfo.Existing(i), null, null));
        }
        return result;
    }

    public ChangeClassSignatureDialog(@NotNull PsiClass aClass, @NotNull List<ChangeClassSignatureFromUsageFix.TypeParameterInfoView> parameters, boolean hideDefaultValueColumn) {
        super(aClass.getProject(), true);
        this.myHideDefaultValueColumn = hideDefaultValueColumn;
        this.setTitle(REFACTORING_NAME);
        this.myClass = aClass;
        this.myProject = this.myClass.getProject();
        this.myOriginalParameters = this.myClass.getTypeParameters();
        this.myTypeParameterInfos = new ArrayList<TypeParameterInfo>(parameters.size());
        this.myBoundValueTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(parameters.size());
        this.myDefaultValueTypeCodeFragments = new ArrayList<PsiTypeCodeFragment>(parameters.size());
        for (ChangeClassSignatureFromUsageFix.TypeParameterInfoView p : parameters) {
            this.myTypeParameterInfos.add(p.getInfo());
            this.myBoundValueTypeCodeFragments.add(p.getBoundValueFragment());
            this.myDefaultValueTypeCodeFragments.add(p.getDefaultValueFragment());
        }
        this.myTableModel = new MyTableModel();
        this.init();
    }

    protected JComponent createNorthPanel() {
        return new JLabel(RefactoringBundle.message((String)"changeClassSignature.class.label.text", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)}));
    }

    protected String getHelpId() {
        return "change.class.signature.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected JComponent createCenterPanel() {
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setStriped(true);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        TableColumn boundColumn = this.myTable.getColumnModel().getColumn(1);
        TableColumn valueColumn = this.myTable.getColumnModel().getColumn(2);
        Project project2 = this.myClass.getProject();
        nameColumn.setCellRenderer((TableCellRenderer)((Object)new MyCellRenderer()));
        nameColumn.setCellEditor(new StringTableCellEditor(project2));
        boundColumn.setCellRenderer(new MyCodeFragmentTableCellRenderer());
        boundColumn.setCellEditor(new JavaCodeFragmentTableCellEditor(project2));
        valueColumn.setCellRenderer(new MyCodeFragmentTableCellRenderer());
        valueColumn.setCellEditor(new JavaCodeFragmentTableCellEditor(project2));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(210, this.myTable.getRowHeight() * 4));
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setFocusCycleRoot(true);
        if (this.myHideDefaultValueColumn) {
            final TableColumn defaultValue = this.myTable.getColumnModel().getColumn(2);
            this.myTable.removeColumn(defaultValue);
            this.myTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 1) {
                        ChangeClassSignatureDialog.this.myTable.getModel().removeTableModelListener(this);
                        TableColumnAnimator animator = new TableColumnAnimator((JTable)ChangeClassSignatureDialog.this.myTable);
                        animator.setStep(20);
                        animator.addColumn(defaultValue, ChangeClassSignatureDialog.this.myTable.getWidth() / 2);
                        animator.startAndDoWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                ChangeClassSignatureDialog.this.myTable.editCellAt(ChangeClassSignatureDialog.this.myTable.getRowCount() - 1, 0);
                            }
                        });
                        animator.start();
                    }
                }
            });
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)RefactoringBundle.message((String)"changeClassSignature.parameters.panel.border.title"), (JComponent)this.myTable), "North");
        panel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myTable).createPanel(), "Center");
        return panel;
    }

    @Override
    protected void doAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        String message = this.validateAndCommitData();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.incorrect.data"), (String)message, (String)"change.class.signature.dialog", (Project)this.myClass.getProject());
            return;
        }
        ChangeClassSignatureProcessor processor2 = new ChangeClassSignatureProcessor(this.myClass.getProject(), this.myClass, this.myTypeParameterInfos.toArray(new TypeParameterInfo[this.myTypeParameterInfos.size()]));
        this.invokeRefactoring(processor2);
    }

    private String validateAndCommitData() {
        PsiTypeParameter[] parameters = this.myClass.getTypeParameters();
        HashMap<String, TypeParameterInfo> infos = new HashMap<String, TypeParameterInfo>();
        for (TypeParameterInfo info : this.myTypeParameterInfos) {
            if (info instanceof TypeParameterInfo.New && !PsiNameHelper.getInstance((Project)this.myClass.getProject()).isIdentifier(info.getName(parameters))) {
                return RefactoringBundle.message((String)"error.wrong.name.input", (Object[])new Object[]{info.getName(parameters)});
            }
            String newName = info.getName(parameters);
            TypeParameterInfo existing = (TypeParameterInfo)infos.get(newName);
            if (existing != null) {
                return this.myClass.getName() + " already contains type parameter " + newName;
            }
            infos.put(newName, info);
        }
        LOG.assertTrue(this.myDefaultValueTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        LOG.assertTrue(this.myBoundValueTypeCodeFragments.size() == this.myTypeParameterInfos.size());
        for (int i = 0; i < this.myDefaultValueTypeCodeFragments.size(); ++i) {
            TypeParameterInfo info;
            info = this.myTypeParameterInfos.get(i);
            if (info instanceof TypeParameterInfo.Existing) continue;
            String message = ChangeClassSignatureDialog.updateInfo(this.myDefaultValueTypeCodeFragments.get(i), (TypeParameterInfo.New)info, InfoUpdater.DEFAULT_VALUE);
            if (message != null) {
                return message;
            }
            message = ChangeClassSignatureDialog.updateInfo(this.myBoundValueTypeCodeFragments.get(i), (TypeParameterInfo.New)info, InfoUpdater.BOUND_VALUE);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private static String updateInfo(PsiTypeCodeFragment source, TypeParameterInfo.New info, InfoUpdater updater) {
        PsiType valueType;
        try {
            valueType = source.getType();
            if (valueType instanceof PsiPrimitiveType) {
                return "Type parameter can't be primitive";
            }
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            return RefactoringBundle.message((String)"changeClassSignature.bad.value", (Object[])new Object[]{updater.getValueName(), source.getText(), info.getName(null)});
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            return updater == InfoUpdater.DEFAULT_VALUE ? RefactoringBundle.message((String)"changeSignature.no.type.for.parameter", (Object[])new Object[]{"default value", info.getName(null)}) : null;
        }
        updater.updateInfo(info, valueType);
        return null;
    }

    public static PsiTypeCodeFragment createTableCodeFragment(@Nullable PsiClassType type, @NotNull PsiElement context, @NotNull JavaCodeFragmentFactory factory, boolean allowConjunctions) {
        return factory.createTypeCodeFragment(type == null ? "" : type.getCanonicalText(), context, true, allowConjunctions && PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) ? 8 : 0);
    }

    private static interface InfoUpdater {
        public static final InfoUpdater DEFAULT_VALUE = new InfoUpdater(){

            @Override
            public void updateInfo(TypeParameterInfo.New info, PsiType type) {
                info.setDefaultValue(type);
            }

            @Override
            public String getValueName() {
                return "default";
            }
        };
        public static final InfoUpdater BOUND_VALUE = new InfoUpdater(){

            @Override
            public void updateInfo(TypeParameterInfo.New info, PsiType type) {
                info.setBoundValue(type);
            }

            @Override
            public String getValueName() {
                return "bound";
            }
        };

        public void updateInfo(TypeParameterInfo.New var1, PsiType var2);

        public String getValueName();
    }

    private class MyCodeFragmentTableCellRenderer
    extends CodeFragmentTableCellRenderer {
        public MyCodeFragmentTableCellRenderer() {
            super(ChangeClassSignatureDialog.this.getProject());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return component;
        }
    }

    private class MyCellRenderer
    extends ColoredTableCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return;
            }
            this.setPaintFocusBorder(false);
            this.acquireState(table, isSelected, false, row, col);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.append((String)value);
        }
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.size();
        }

        @Nullable
        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((TypeParameterInfo)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).getName(ChangeClassSignatureDialog.this.myOriginalParameters);
                }
                case 1: {
                    return ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.get(rowIndex);
                }
                case 2: {
                    return ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.get(rowIndex);
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex) instanceof TypeParameterInfo.New;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return RefactoringBundle.message((String)"column.name.name");
                }
                case 1: {
                    return RefactoringBundle.message((String)"changeSignature.bound.value.column");
                }
                case 2: {
                    return RefactoringBundle.message((String)"changeSignature.default.value.column");
                }
            }
            LOG.assertTrue(false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((TypeParameterInfo.New)ChangeClassSignatureDialog.this.myTypeParameterInfos.get(rowIndex)).setNewName((String)aValue);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
        }

        public void addRow() {
            TableUtil.stopEditing((JTable)ChangeClassSignatureDialog.this.myTable);
            ChangeClassSignatureDialog.this.myTypeParameterInfos.add(new TypeParameterInfo.New("", null, null));
            JavaCodeFragmentFactory codeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)ChangeClassSignatureDialog.this.myProject);
            PsiClass context = ChangeClassSignatureDialog.this.myClass.getLBrace() != null ? ChangeClassSignatureDialog.this.myClass.getLBrace() : ChangeClassSignatureDialog.this.myClass;
            ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.add(ChangeClassSignatureDialog.createTableCodeFragment(null, (PsiElement)context, codeFragmentFactory, true));
            ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.add(ChangeClassSignatureDialog.createTableCodeFragment(null, (PsiElement)context, codeFragmentFactory, false));
            int row = ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void removeRow(int index) {
            ChangeClassSignatureDialog.this.myTypeParameterInfos.remove(index);
            ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments.remove(index);
            ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments.remove(index);
            this.fireTableDataChanged();
        }

        public void exchangeRows(int index1, int index2) {
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myTypeParameterInfos, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myBoundValueTypeCodeFragments, (int)index1, (int)index2);
            ContainerUtil.swapElements((List)ChangeClassSignatureDialog.this.myDefaultValueTypeCodeFragments, (int)index1, (int)index2);
            this.fireTableDataChanged();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

