/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(Editor editor, List<T> expressions, Pass<T> callback, Function<T, String> renderer) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback, renderer, "Expressions");
    }

    public static <T extends PsiElement> void showChooser(Editor editor, List<T> expressions, Pass<T> callback, Function<T, String> renderer, String title) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback, renderer, title, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(Editor editor, List<T> expressions, Pass<T> callback, Function<T, String> renderer, String title, NotNullFunction<PsiElement, TextRange> ranger) {
        IntroduceTargetChooser.showChooser(editor, expressions, callback, renderer, title, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(Editor editor, List<T> expressions, Pass<T> callback, final Function<T, String> renderer, String title, int selection, NotNullFunction<PsiElement, TextRange> ranger) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor, ranger);
        DefaultListModel<SmartPsiElementPointer> model = new DefaultListModel<SmartPsiElementPointer>();
        for (PsiElement expr : expressions) {
            model.addElement(SmartPointerManager.getInstance((Project)expr.getProject()).createSmartPsiElementPointer(expr));
        }
        JBList list = new JBList(model);
        AccessibleContextUtil.setName((Component)list, (String)title);
        list.getSelectionModel().setSelectionMode(0);
        if (selection > -1) {
            list.setSelectedIndex(selection);
        }
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)value;
                PsiElement expr = pointer.getElement();
                if (expr != null) {
                    String text;
                    int firstNewLinePos = (text = (String)renderer.fun((Object)expr)).indexOf(10);
                    String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text.length()));
                    if (trimmedText.length() != text.length()) {
                        trimmedText = trimmedText + " ...";
                    }
                    this.setText(trimmedText);
                } else {
                    this.setForeground((Color)JBColor.RED);
                    this.setText("Invalid");
                }
                return rendererComponent;
            }
        });
        list.addListSelectionListener(new ListSelectionListener((JList)list, model){
            final /* synthetic */ JList val$list;
            final /* synthetic */ DefaultListModel val$model;
            {
                this.val$list = jList;
                this.val$model = defaultListModel;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                highlighter.dropHighlight();
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)this.val$model.get(index);
                PsiElement expr = pointer.getElement();
                if (expr != null) {
                    highlighter.highlight(expr, Collections.singletonList(expr));
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list, callback){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Pass val$callback;
            {
                this.val$list = jList;
                this.val$callback = pass;
            }

            @Override
            public void run() {
                PsiElement expr;
                SmartPsiElementPointer value = (SmartPsiElementPointer)this.val$list.getSelectedValue();
                PsiElement psiElement = expr = value != null ? value.getElement() : null;
                if (expr != null) {
                    this.val$callback.pass((Object)expr);
                }
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor);
    }
}

