/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.ClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.HierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.stubs.UnitInfo;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Symbols {
    public final Symbol.PackageSymbol myRootPackage;
    protected final NameEnvironment myNameEnvironment;
    protected Symbol.ClassSymbol[] myClassSymbols = new Symbol.ClassSymbol[32768];
    public final TIntObjectHashMap<Symbol.PackageSymbol> myPackages = new TIntObjectHashMap();
    private Object[] myClassSymbolsByNameId = new Object[32768];
    protected int id;

    protected Symbols(NameEnvironment nameEnvironment) {
        this.myNameEnvironment = nameEnvironment;
        this.myRootPackage = new Symbol.PackageSymbol(null, nameEnvironment.empty, 0);
        this.myPackages.put(nameEnvironment.empty.myId, (Object)this.myRootPackage);
    }

    public Symbol.PackageSymbol enterPackage(QualifiedName qualifiedName) {
        Symbol.PackageSymbol p = (Symbol.PackageSymbol)this.myPackages.get(qualifiedName.myId);
        if (p == null) {
            Symbol.PackageSymbol owner = this.enterPackage(this.myNameEnvironment.prefix(qualifiedName));
            int shortName = this.myNameEnvironment.shortName(qualifiedName);
            p = new Symbol.PackageSymbol(owner, qualifiedName, shortName);
            this.myPackages.put(qualifiedName.myId, (Object)p);
        }
        return p;
    }

    @Nullable
    public Symbol.PackageSymbol getPackage(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        return (Symbol.PackageSymbol)this.myPackages.get(qualifiedName.myId);
    }

    @NotNull
    public Symbol.ClassSymbol[] loadClass(@NotNull QualifiedName qualifiedName) {
        int i = qualifiedName.myId;
        if (i >= this.myClassSymbolsByNameId.length) {
            return Symbol.ClassSymbol.EMPTY_ARRAY;
        }
        return this.getClassSymbols(i);
    }

    private Symbol.ClassSymbol[] getClassSymbols(int id) {
        Object cs = this.myClassSymbolsByNameId[id];
        if (cs == null) {
            return Symbol.ClassSymbol.EMPTY_ARRAY;
        }
        if (cs instanceof Symbol.ClassSymbol) {
            return new Symbol.ClassSymbol[]{(Symbol.ClassSymbol)cs};
        }
        return (Symbol.ClassSymbol[])cs;
    }

    public Symbol.ClassSymbol enterClass(ClassAnchor classAnchor, int flags, int shortName, Symbol owner, UnitInfo info, QualifiedName[] supers, HierarchyConnector connector) {
        QualifiedName qualifiedName = this.myNameEnvironment.qualifiedName(owner, shortName);
        SmartClassAnchor smartClassAnchor = SmartClassAnchor.create(this.id++, classAnchor);
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(smartClassAnchor, flags, owner, qualifiedName, shortName, info, supers, connector);
        this.putClass(c);
        return c;
    }

    private void putClass(Symbol.ClassSymbol classSymbol) {
        this.putClassById(classSymbol);
        this.putClassByName(classSymbol);
    }

    private void putClassById(Symbol.ClassSymbol classSymbol) {
        this.ensureByIdCapacity(classSymbol.myClassAnchor.myId);
        this.myClassSymbols[classSymbol.myClassAnchor.myId] = classSymbol;
    }

    private void putClassByName(Symbol.ClassSymbol classSymbol) {
        QualifiedName name = classSymbol.myQualifiedName;
        if (name == null) {
            return;
        }
        int nameId = name.myId;
        this.ensureByNameCapacity(nameId);
        Object cs = this.myClassSymbolsByNameId[nameId];
        if (cs == null) {
            this.myClassSymbolsByNameId[nameId] = classSymbol;
        } else if (cs instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)cs;
            this.myClassSymbolsByNameId[nameId] = new Symbol.ClassSymbol[]{c, classSymbol};
        } else {
            Symbol.ClassSymbol[] css = (Symbol.ClassSymbol[])cs;
            Symbol.ClassSymbol[] newCss = new Symbol.ClassSymbol[css.length + 1];
            System.arraycopy(css, 0, newCss, 0, css.length);
            newCss[css.length] = classSymbol;
            this.myClassSymbolsByNameId[nameId] = newCss;
        }
    }

    private void ensureByNameCapacity(int maxIndex) {
        if (maxIndex >= this.myClassSymbolsByNameId.length) {
            int newLength = Symbols.calculateNewLength(this.myClassSymbolsByNameId.length, maxIndex);
            Object[] result = new Object[newLength];
            System.arraycopy(this.myClassSymbolsByNameId, 0, result, 0, this.myClassSymbolsByNameId.length);
            this.myClassSymbolsByNameId = result;
        }
    }

    private void ensureByIdCapacity(int maxIndex) {
        if (maxIndex >= this.myClassSymbols.length) {
            int newLength = Symbols.calculateNewLength(this.myClassSymbols.length, maxIndex);
            Symbol.ClassSymbol[] result = new Symbol.ClassSymbol[newLength];
            System.arraycopy(this.myClassSymbols, 0, result, 0, this.myClassSymbols.length);
            this.myClassSymbols = result;
        }
    }

    private static int calculateNewLength(int currentLength, int maxIndex) {
        while (currentLength < maxIndex + 1) {
            currentLength *= 2;
        }
        return currentLength;
    }

    public SingleClassHierarchy createHierarchy() {
        SingleClassHierarchy table = new SingleClassHierarchy(this.myClassSymbols, this.id);
        table.connectSubTypes(this.myClassSymbols, this.id);
        this.myClassSymbols = null;
        return table;
    }
}

