/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.HierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.stubs.UnitInfo;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public abstract class Symbol {
    public int myFlags;
    public int myShortName;
    public final QualifiedName myQualifiedName;
    public final Symbol myOwner;
    public static final Comparator<ClassSymbol> CLASS_SYMBOL_BY_NAME_COMPARATOR = new Comparator<ClassSymbol>(){

        @Override
        public int compare(ClassSymbol s1, ClassSymbol s2) {
            int name1 = s1.myShortName;
            int name2 = s2.myShortName;
            return name1 < name2 ? -1 : (name1 == name2 ? 0 : 1);
        }
    };

    public Symbol(int flags, Symbol owner, QualifiedName qualifiedName, int name) {
        this.myFlags = flags;
        this.myOwner = owner;
        this.myQualifiedName = qualifiedName;
        this.myShortName = name;
    }

    public ClassSymbol[] members() {
        return ClassSymbol.EMPTY_ARRAY;
    }

    public void setMembers(ClassSymbol[] members) {
    }

    public boolean isStatic() {
        return (this.myFlags & 8) != 0;
    }

    public boolean isPackage() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isClass() {
        return (this.myFlags & 2) != 0;
    }

    public boolean isMember() {
        return (this.myFlags & 0x100) != 0;
    }

    public PackageSymbol pkg() {
        Symbol sym = this;
        while (!sym.isPackage()) {
            sym = sym.myOwner;
        }
        return (PackageSymbol)sym;
    }

    public static class MemberSymbol
    extends Symbol {
        private ClassSymbol[] myMembers;

        public MemberSymbol(Symbol owner) {
            super(256, owner, null, 0);
        }

        @Override
        public ClassSymbol[] members() {
            return this.myMembers;
        }

        @Override
        public void setMembers(ClassSymbol[] members) {
            this.myMembers = members;
        }
    }

    public static class ClassSymbol
    extends Symbol {
        public static final ClassSymbol[] EMPTY_ARRAY = new ClassSymbol[0];
        public final SmartClassAnchor myClassAnchor;
        public ClassSymbol[] mySuperClasses;
        public UnitInfo myUnitInfo;
        public QualifiedName[] mySuperNames;
        private ClassSymbol[] myMembers;
        private HierarchyConnector myConnector;

        public ClassSymbol(SmartClassAnchor classAnchor, int flags, Symbol owner, QualifiedName fullname, int name, UnitInfo unitInfo, QualifiedName[] supers, HierarchyConnector connector) {
            super(flags | 2, owner, fullname, name);
            this.myClassAnchor = classAnchor;
            this.mySuperNames = supers;
            this.myUnitInfo = unitInfo;
            this.myConnector = connector;
        }

        public void connect() {
            if (this.myConnector != null) {
                HierarchyConnector c = this.myConnector;
                this.myConnector = null;
                c.connect(this);
            }
        }

        @NotNull
        public ClassSymbol[] getSuperClasses() {
            this.connect();
            if (this.mySuperClasses == null) {
                return EMPTY_ARRAY;
            }
            return this.mySuperClasses;
        }

        public boolean isCompiled() {
            return (this.myFlags & 0x80) != 0;
        }

        @Override
        public ClassSymbol[] members() {
            return this.myMembers;
        }

        @Override
        public void setMembers(ClassSymbol[] members) {
            this.myMembers = members;
        }
    }

    public static class PackageSymbol
    extends Symbol {
        public PackageSymbol(Symbol owner, QualifiedName fullname, int name) {
            super(1, owner, fullname, name);
            this.setMembers(ClassSymbol.EMPTY_ARRAY);
        }
    }
}

