/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.stubsHierarchy.impl.Translator;
import com.intellij.psi.stubsHierarchy.stubs.Import;
import com.intellij.psi.stubsHierarchy.stubs.UnitInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StubResolver {
    private final Symbols mySymbols;
    private final NameEnvironment myNameEnvironment;

    public StubResolver(Symbols symbols) {
        this.mySymbols = symbols;
        this.myNameEnvironment = symbols.myNameEnvironment;
    }

    public Set<Symbol> resolveBase(Symbol.ClassSymbol sym, int[] baseId) {
        Set<Symbol> prev = null;
        Set<Symbol> result = null;
        for (int i = 0; i < baseId.length; ++i) {
            int k;
            int name = baseId[i];
            int n = k = i == baseId.length - 1 ? 2 : 3;
            if (i == 0) {
                result = this.findIdent(sym.myOwner, sym.myUnitInfo, name, k);
            } else {
                HashSet<Symbol> acc = new HashSet<Symbol>();
                for (Symbol symbol : prev) {
                    this.selectSym(symbol, name, k, acc);
                }
                result = acc;
            }
            prev = result;
        }
        return result;
    }

    @NotNull
    private Set<Symbol> findIdent(Symbol startScope, UnitInfo info, int name, int kind) {
        Symbol.PackageSymbol pkg;
        HashSet<Symbol> result = new HashSet<Symbol>();
        if ((kind & 2) != 0) {
            this.findType(startScope, name, result);
            this.findGlobalType(info, name, result);
        }
        if ((kind & 1) != 0 && (pkg = this.mySymbols.getPackage(this.myNameEnvironment.qualifiedName(null, name, false))) != null) {
            result.add(pkg);
        }
        return result;
    }

    private void findType(Symbol startScope, int name, Set<Symbol> symbols) {
        Symbol s = startScope;
        while (s != null) {
            StubResolver.findMemberType(s, name, symbols, new HashSet<Symbol>());
            s = s.myOwner;
        }
        this.findIdentInPackage(startScope.pkg(), name, 2, symbols);
    }

    private void selectSym(Symbol receiver, int name, int kind, Set<Symbol> symbols) {
        if (receiver.isPackage()) {
            this.findIdentInPackage((Symbol.PackageSymbol)receiver, name, kind, symbols);
        } else {
            StubResolver.findMemberType(receiver, name, symbols, new HashSet<Symbol>());
        }
    }

    private void findIdentInPackage(Symbol.PackageSymbol pck, int name, int kind, Set<Symbol> symbols) {
        Symbol.PackageSymbol pkg;
        QualifiedName fullname = this.mySymbols.myNameEnvironment.qualifiedName(pck.myQualifiedName, name, false);
        if (fullname == null) {
            return;
        }
        if ((kind & 1) != 0 && (pkg = this.mySymbols.getPackage(fullname)) != null) {
            symbols.add(pkg);
        }
        if ((kind & 2) != 0) {
            Collections.addAll(symbols, this.loadClass(fullname));
        }
    }

    private static void findMemberType(Symbol s, int name, Set<Symbol> symbols, Set<Symbol> processed2) {
        if (!processed2.add(s)) {
            return;
        }
        StubResolver.findImmediateMemberType(s, name, symbols);
        if (s.isClass()) {
            StubResolver.findInheritedMemberType((Symbol.ClassSymbol)s, name, symbols, processed2);
        }
    }

    private static void findImmediateMemberType(Symbol s, int name, Set<Symbol> symbols) {
        int i;
        Symbol.ClassSymbol[] members = s.members();
        int index = StubResolver.getIndex(name, members);
        if (index < 0) {
            return;
        }
        Symbol.ClassSymbol member = members[index];
        symbols.add(member);
        for (i = index - 1; i >= 0 && members[i].myShortName == name; --i) {
            member = members[i];
            symbols.add(member);
        }
        for (i = index + 1; i < members.length && members[i].myShortName == name; ++i) {
            member = members[i];
            symbols.add(member);
        }
    }

    private static void findInheritedMemberType(Symbol.ClassSymbol c, int name, Set<Symbol> symbols, Set<Symbol> processed2) {
        for (Symbol.ClassSymbol st : c.getSuperClasses()) {
            StubResolver.findMemberType(st, name, symbols, processed2);
        }
    }

    private Symbol.ClassSymbol[] loadClass(@NotNull QualifiedName fqn) {
        return this.mySymbols.loadClass(fqn);
    }

    public Symbol.ClassSymbol[] findGlobalType(@NotNull QualifiedName name) {
        return this.loadClass(name);
    }

    private void findGlobalType(UnitInfo info, int name, Set<Symbol> symbols) {
        for (long anImport : Translator.getDefaultImports(info.getType(), this.myNameEnvironment)) {
            this.handleImport(anImport, name, symbols);
        }
        for (long anImport : info.getImports()) {
            this.handleImport(anImport, name, symbols);
        }
    }

    public void handleImport(long tree, int name, Set<Symbol> symbols) {
        QualifiedName fullname = Import.getFullName(tree, this.myNameEnvironment);
        if (Import.isOnDemand(tree)) {
            if (Import.isStatic(tree)) {
                for (Symbol.ClassSymbol p : this.findGlobalType(fullname)) {
                    StubResolver.importStaticAll(p, name, symbols);
                }
            } else {
                this.importAll(fullname, name, symbols);
            }
        } else {
            boolean shouldImport;
            QualifiedName prefix = this.myNameEnvironment.prefix(fullname);
            if (prefix.isEmpty()) {
                return;
            }
            int shortName = this.myNameEnvironment.shortName(fullname);
            int alias = Import.getAlias(tree);
            boolean bl = shouldImport = (alias & name) == name || shortName == name;
            if (!shouldImport) {
                return;
            }
            if (Import.isStatic(tree)) {
                for (Symbol.ClassSymbol s : this.findGlobalType(prefix)) {
                    StubResolver.importNamedStatic(s, shortName, symbols);
                }
            } else {
                Collections.addAll(symbols, this.findGlobalType(fullname));
            }
        }
    }

    private void importAll(@NotNull QualifiedName prefix, int suffix, Set<Symbol> symbols) {
        QualifiedName fullname = this.myNameEnvironment.qualifiedName(prefix, suffix, false);
        if (fullname != null) {
            Symbol.ClassSymbol[] ss = this.findGlobalType(fullname);
            Collections.addAll(symbols, ss);
        }
    }

    private static void importStaticAll(Symbol.ClassSymbol tsym, final int name, final Set<Symbol> symbols) {
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.ClassSymbol cs) {
                if (cs == null || !this.processed.add(cs)) {
                    return;
                }
                for (Symbol.ClassSymbol c : cs.getSuperClasses()) {
                    this.importFrom(c);
                }
                StubResolver.importMember(cs.members(), name, symbols, true);
            }
        }.importFrom(tsym);
    }

    private static void importNamedStatic(Symbol.ClassSymbol tsym, final int name, final Set<Symbol> symbols) {
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.ClassSymbol cs) {
                if (cs == null || !this.processed.add(cs)) {
                    return;
                }
                for (Symbol.ClassSymbol c : cs.getSuperClasses()) {
                    this.importFrom(c);
                }
                StubResolver.importMember(cs.members(), name, symbols, true);
            }
        }.importFrom(tsym);
    }

    private static void importMember(Symbol.ClassSymbol[] members, int name, Set<Symbol> symbols, boolean isStatic) {
        int i;
        int index = StubResolver.getIndex(name, members);
        if (index < 0) {
            return;
        }
        Symbol.ClassSymbol member = members[index];
        if (!isStatic || member.isStatic()) {
            symbols.add(member);
        }
        for (i = index - 1; i >= 0 && members[i].myShortName == name; --i) {
            member = members[i];
            if (isStatic && !member.isStatic()) continue;
            symbols.add(member);
        }
        for (i = index + 1; i < members.length && members[i].myShortName == name; ++i) {
            member = members[i];
            if (isStatic && !member.isStatic()) continue;
            symbols.add(member);
        }
    }

    private static int getIndex(int key, Symbol.ClassSymbol[] a) {
        int lo = 0;
        int hi = a.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            if (key < a[mid].myShortName) {
                hi = mid - 1;
                continue;
            }
            if (key > a[mid].myShortName) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }
}

