/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.PsiEnter;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.StubEnter;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import com.intellij.psi.stubsHierarchy.impl.Translator;
import com.intellij.psi.stubsHierarchy.stubs.Unit;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NotNull;

public class HierarchyService {
    public static boolean PROCESS_PSI = true;
    public static boolean IGNORE_LOCAL_CLASSES = true;
    public static final String HIERARCHY_SERVICE = "java.hierarchy.service";
    private NameEnvironment myNameEnvironment;
    private SoftReference<NameEnvironment> myNamesCache = new SoftReference(null);
    private SingleClassHierarchy mySingleClassHierarchy;
    private Symbols mySymbols;
    private StubEnter myStubEnter;
    private PsiEnter myPsiEnter;

    public static HierarchyService instance(Project project2) {
        return (HierarchyService)ServiceManager.getService((Project)project2, HierarchyService.class);
    }

    public static boolean isEnabled() {
        return Registry.is((String)HIERARCHY_SERVICE);
    }

    public HierarchyService() {
        this.clear();
    }

    public void processUnit(IndexTree.Unit unit) {
        Unit compUnit = Translator.translate(this.myNameEnvironment, unit);
        if (compUnit != null) {
            this.myStubEnter.unitEnter(compUnit);
        }
    }

    public void processPsiClassOwner(@NotNull PsiClassOwner psiClassOwner) {
        this.myPsiEnter.enter(psiClassOwner);
    }

    public void connect1() {
        this.myStubEnter.connect1();
    }

    public void complete2() {
        this.myStubEnter.connect2();
        this.myPsiEnter.connect();
        this.myStubEnter = null;
        this.myPsiEnter = null;
    }

    public void connectSubtypes() {
        this.mySingleClassHierarchy = this.mySymbols.createHierarchy();
        this.mySymbols = null;
    }

    public SingleClassHierarchy getSingleClassHierarchy() {
        return this.mySingleClassHierarchy;
    }

    public void clear() {
        this.myNameEnvironment = (NameEnvironment)((Object)this.myNamesCache.get());
        if (this.myNameEnvironment == null) {
            this.myNameEnvironment = new NameEnvironment();
            this.myNamesCache = new SoftReference((Object)this.myNameEnvironment);
        }
        this.mySymbols = new Symbols(this.myNameEnvironment);
        this.myStubEnter = new StubEnter(this.myNameEnvironment, this.mySymbols);
        this.myPsiEnter = new PsiEnter(this.myNameEnvironment, this.mySymbols);
        this.mySingleClassHierarchy = null;
    }
}

