/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeLoaderImpl
extends StubTreeLoader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubTreeLoaderImpl");

    @Override
    @Nullable
    public ObjectStubTree readOrBuild(Project project2, VirtualFile vFile, @Nullable PsiFile psiFile) {
        ObjectStubTree fromIndices = this.readFromVFile(project2, vFile);
        if (fromIndices != null) {
            return fromIndices;
        }
        try {
            Stub element;
            FileContentImpl fc = new FileContentImpl(vFile, vFile.contentsToByteArray());
            fc.putUserData(IndexingDataKeys.PROJECT, project2);
            if (psiFile != null && !vFile.getFileType().isBinary()) {
                fc.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, psiFile.getViewProvider().getContents());
            }
            if ((element = (Stub)RecursionManager.doPreventingRecursion((Object)vFile, (boolean)false, () -> StubTreeBuilder.buildStubTree(fc))) instanceof PsiFileStub) {
                StubTree tree = new StubTree((PsiFileStub)element);
                tree.setDebugInfo("created from file content");
                return tree;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @Override
    @Nullable
    public ObjectStubTree readFromVFile(Project project2, VirtualFile vFile) {
        if (DumbService.getInstance((Project)project2).isDumb()) {
            return null;
        }
        int id = Math.abs(FileBasedIndex.getFileId((VirtualFile)vFile));
        if (id <= 0) {
            return null;
        }
        boolean wasIndexedAlready = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).isFileUpToDate(vFile);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        boolean saved = document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document);
        List datas = FileBasedIndex.getInstance().getValues(StubUpdatingIndex.INDEX_ID, (Object)id, GlobalSearchScope.fileScope((Project)project2, (VirtualFile)vFile));
        int size = datas.size();
        if (size == 1) {
            Stub stub;
            SerializedStubTree stubTree = (SerializedStubTree)datas.get(0);
            if (!stubTree.contentLengthMatches(vFile.getLength(), StubTreeLoaderImpl.getCurrentTextContentLength(project2, vFile, document))) {
                return StubTreeLoaderImpl.processError(vFile, "Outdated stub in index: " + StubUpdatingIndex.getIndexingStampInfo(vFile) + ", doc=" + document + ", docSaved=" + saved + ", wasIndexedAlready=" + wasIndexedAlready + ", queried at " + vFile.getTimeStamp(), null);
            }
            try {
                stub = stubTree.getStub(false);
            }
            catch (SerializerNotFoundException e) {
                return StubTreeLoaderImpl.processError(vFile, "No stub serializer: " + vFile.getPresentableUrl() + ": " + e.getMessage(), (Exception)((Object)e));
            }
            ObjectStubTree tree = stub instanceof PsiFileStub ? new StubTree((PsiFileStub)stub) : new ObjectStubTree((ObjectStubBase)stub, true);
            tree.setDebugInfo("created from index");
            return tree;
        }
        if (size != 0) {
            return StubTreeLoaderImpl.processError(vFile, "Twin stubs: " + vFile.getPresentableUrl() + " has " + size + " stub versions. Should only have one. id=" + id, null);
        }
        return null;
    }

    private static int getCurrentTextContentLength(Project project2, VirtualFile vFile, Document document) {
        if (vFile.getFileType().isBinary()) {
            return -1;
        }
        PsiFile psiFile = ((PsiManagerEx)PsiManager.getInstance((Project)project2)).getFileManager().getCachedPsiFile(vFile);
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            return psiFile.getTextLength();
        }
        if (document != null) {
            return PsiDocumentManager.getInstance((Project)project2).getLastCommittedText(document).length();
        }
        return -1;
    }

    private static ObjectStubTree processError(final VirtualFile vFile, String message, @Nullable Exception e) {
        LOG.error(message, (Throwable)e);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
                if (doc != null) {
                    FileDocumentManager.getInstance().saveDocument(doc);
                }
            }
        }, ModalityState.NON_MODAL);
        FileBasedIndex.getInstance().requestReindex(vFile);
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
        FileBasedIndex.getInstance().requestReindex(virtualFile);
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        return StubUpdatingIndex.canHaveStub(file2);
    }

    private boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        VirtualFile file2 = virtualFile;
        int count = 0;
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (((PsiManagerEx)PsiManager.getInstance((Project)project2)).getFileManager().findCachedViewProvider(file2) == null) continue;
            ++count;
        }
        return count > 1;
    }

    @Override
    public String getStubAstMismatchDiagnostics(@NotNull VirtualFile file2, @NotNull PsiFile psiFile, @NotNull ObjectStubTree stubTree, Document prevCachedDocument) {
        String msg = super.getStubAstMismatchDiagnostics(file2, psiFile, stubTree, prevCachedDocument);
        msg = msg + "\nin many projects: " + this.hasPsiInManyProjects(file2);
        msg = msg + "\nindexing info: " + StubUpdatingIndex.getIndexingStampInfo(file2);
        return msg;
    }
}

