/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubSerializationHelper {
    private final AbstractStringEnumerator myNameStorage;
    protected final TIntObjectHashMap<ObjectStubSerializer> myIdToSerializer = new TIntObjectHashMap();
    protected final TObjectIntHashMap<ObjectStubSerializer> mySerializerToId = new TObjectIntHashMap();
    private final RecentStringInterner myStringInterner = new RecentStringInterner();

    public StubSerializationHelper(@NotNull AbstractStringEnumerator nameStorage) {
        this.myNameStorage = nameStorage;
    }

    public void assignId(@NotNull ObjectStubSerializer serializer) throws IOException {
        int id = this.persistentId(serializer);
        ObjectStubSerializer old = (ObjectStubSerializer)this.myIdToSerializer.put(id, (Object)serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        int oldId = this.mySerializerToId.put((Object)serializer, id);
        assert (oldId == 0) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull ObjectStubSerializer serializer) throws IOException {
        return this.myNameStorage.enumerate((Object)serializer.getExternalId());
    }

    private void doSerialize(@NotNull Stub rootStub, @NotNull StubOutputStream stream) throws IOException {
        ObjectStubSerializer serializer = StubSerializationUtil.getSerializer((Stub)rootStub);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.getClassId(serializer));
        serializer.serialize(rootStub, stream);
        List children2 = rootStub.getChildrenStubs();
        int childrenSize = children2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)childrenSize);
        for (int i = 0; i < childrenSize; ++i) {
            this.doSerialize((Stub)children2.get(i), stream);
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(true);
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage2);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStub) {
            PsiFileStub[] roots = ((PsiFileStub)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.doSerialize((Stub)root, stubOutputStream);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.doSerialize(rootStub, stubOutputStream);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        DataInputOutputUtil.writeINT((DataOutput)resultStream, (int)storage2.myStrings.size());
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        for (String s : storage2.myStrings) {
            IOUtil.writeUTFFast((byte[])buffer, (DataOutput)resultStream, (String)s);
        }
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(ObjectStubSerializer serializer) {
        int idValue = this.mySerializerToId.get((Object)serializer);
        assert (idValue != 0) : "No ID found for serializer " + LogUtil.objectAndClass((Object)serializer);
        return idValue;
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(false);
        StubInputStream inputStream = new StubInputStream(stream, (AbstractStringEnumerator)storage2);
        int numberOfStrings = DataInputOutputUtil.readINT((DataInput)inputStream);
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        storage2.myStrings.ensureCapacity(numberOfStrings);
        for (int i = 0; i < numberOfStrings; ++i) {
            String s = this.myStringInterner.get(IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream));
            storage2.myStrings.add(s);
        }
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserialize(inputStream, null);
        ArrayList stubs = ContainerUtil.newArrayListWithCapacity((int)stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserialize(inputStream, null);
            if (deserialize instanceof PsiFileStub) {
                PsiFileStub fileStub = (PsiFileStub)deserialize;
                stubs.add(fileStub);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(new PsiFileStub[stubs.size()])) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        return baseStub;
    }

    String intern(String str) {
        return this.myStringInterner.get(str);
    }

    @NotNull
    private Stub deserialize(@NotNull StubInputStream stream, @Nullable Stub parentStub) throws IOException, SerializerNotFoundException {
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        ObjectStubSerializer serializer = this.getClassById(id);
        if (serializer == null) {
            String externalId = null;
            try {
                externalId = (String)this.myNameStorage.valueOf(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SerializerNotFoundException("No serializer registered for stub: ID=" + id + ", externalId:" + externalId + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() : "null"));
        }
        Stub stub = serializer.deserialize(stream, parentStub);
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            this.deserialize(stream, stub);
        }
        return stub;
    }

    private ObjectStubSerializer getClassById(int id) {
        return (ObjectStubSerializer)this.myIdToSerializer.get(id);
    }

    private static class FileLocalStringEnumerator
    implements AbstractStringEnumerator {
        private final TObjectIntHashMap<String> myEnumerates;
        private final ArrayList<String> myStrings = new ArrayList();

        FileLocalStringEnumerator(boolean forSavingStub) {
            this.myEnumerates = forSavingStub ? new TObjectIntHashMap() : null;
        }

        public int enumerate(@Nullable String value) throws IOException {
            if (value == null) {
                return 0;
            }
            assert (this.myEnumerates != null);
            int i = this.myEnumerates.get((Object)value);
            if (i == 0) {
                i = this.myStrings.size() + 1;
                this.myEnumerates.put((Object)value, i);
                this.myStrings.add(value);
            }
            return i;
        }

        public String valueOf(int idx) throws IOException {
            if (idx == 0) {
                return null;
            }
            return this.myStrings.get(idx - 1);
        }

        public void markCorrupted() {
        }

        public void close() throws IOException {
        }

        public boolean isDirty() {
            return false;
        }

        public void force() {
        }
    }
}

