/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MapDiffUpdateData;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", storages={@Storage(value="stubIndex.xml", roamingType=RoamingType.DISABLED)})
public class StubIndexImpl
extends StubIndex
implements ApplicationComponent,
PersistentStateComponent<StubIndexState> {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new THashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final StubProcessingHelper myStubProcessingHelper;
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl(FileBasedIndex fileBasedIndex) throws IOException {
        this.myStubProcessingHelper = new StubProcessingHelper(fileBasedIndex);
    }

    @Nullable
    public static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private <K> boolean registerIndexer(@NotNull StubIndexExtension<K, ?> extension, boolean forceClean) throws IOException {
        StubIndexKey indexKey = extension.getKey();
        int version = extension.getVersion();
        this.myIndexIdToVersionMap.put((Object)indexKey, version);
        File versionFile = IndexInfrastructure.getVersionFile(indexKey);
        boolean versionFileExisted = versionFile.exists();
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (forceClean || IndexingStamp.versionDiffers(versionFile, version)) {
            String[] children2 = indexRootDir.list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            }
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir);
            }
            IndexingStamp.rewriteVersion(versionFile, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                MapIndexStorage storage2 = new MapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), new StubIdExternalizer(), extension.getCacheSize(), false, extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage2);
                this.myIndices.put(indexKey, new MyIndex(memStorage));
                break;
            }
            catch (IOException e) {
                needRebuild = true;
                StubIndexImpl.onExceptionInstantiatingIndex(version, versionFile, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(version, versionFile, indexRootDir, e);
            }
        }
        return needRebuild;
    }

    private static void onExceptionInstantiatingIndex(int version, File versionFile, File indexRootDir, Exception e) throws IOException {
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir);
        IndexingStamp.rewriteVersion(versionFile, version);
    }

    @NotNull
    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project2, @Nullable GlobalSearchScope scope) {
        return this.get(indexKey, key, project2, scope, null);
    }

    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project2, @Nullable GlobalSearchScope scope, IdFilter filter) {
        SmartList result = new SmartList();
        this.process(indexKey, key, project2, scope, filter, (Processor)new CommonProcessors.CollectProcessor((Collection)result));
        return result;
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project2, @Nullable GlobalSearchScope scope, Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor2) {
        return this.processElements(indexKey, key, project2, scope, null, requiredClass, processor2);
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, final @NotNull Project project2, final @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, final @NotNull Class<Psi> requiredClass, final @NotNull Processor<? super Psi> processor2) {
        return this.doProcessStubs(indexKey, key, project2, scope, new StubIdListContainerAction(idFilter, project2){
            final PersistentFS fs;
            {
                super(idFilter, project22);
                this.fs = (PersistentFS)ManagingFS.getInstance();
            }

            @Override
            protected boolean process(int id, StubIdList value) {
                VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(this.fs, id);
                if (file2 == null || scope != null && !scope.contains(file2)) {
                    return true;
                }
                return StubIndexImpl.this.myStubProcessingHelper.processStubsInFile(project2, file2, value, processor2, requiredClass);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Key> boolean doProcessStubs(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key, @NotNull Project project2, @Nullable GlobalSearchScope scope, @NotNull StubIdListContainerAction action) {
        block8: {
            boolean bl;
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            fileBasedIndex.ensureUpToDate(StubUpdatingIndex.INDEX_ID, project2, scope);
            MyIndex<?> index = this.myIndices.get(indexKey);
            this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing((ID<?, ?>)indexKey);
            try {
                FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
                index.getReadLock().lock();
                this.myAccessValidator.startedProcessingActivityForIndex((ID<?, ?>)indexKey);
                bl = index.getData(key).forEach(action);
                this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
                index.getReadLock().unlock();
            }
            catch (Throwable throwable) {
                try {
                    this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
                    index.getReadLock().unlock();
                    FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
                    throw throwable;
                }
                catch (StorageException e) {
                    this.forceRebuild(e);
                    break block8;
                }
                catch (RuntimeException e) {
                    Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                    if (cause != null) {
                        this.forceRebuild(cause);
                        break block8;
                    }
                    throw e;
                }
                catch (AssertionError ae) {
                    this.forceRebuild((Throwable)((Object)ae));
                }
            }
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
            return bl;
        }
        return true;
    }

    public void forceRebuild(@NotNull Throwable e) {
        LOG.info(e);
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project2) {
        THashSet allKeys = ContainerUtil.newTroveSet();
        this.processAllKeys(indexKey, project2, (Processor<K>)new CommonProcessors.CollectProcessor((Collection)allKeys));
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project2, Processor<K> processor2) {
        return this.processAllKeys(indexKey, processor2, GlobalSearchScope.allScope((Project)project2), null);
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope);
        MyIndex<?> index = this.myIndices.get(indexKey);
        this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing((ID<?, ?>)indexKey);
        try {
            this.myAccessValidator.startedProcessingActivityForIndex((ID<?, ?>)indexKey);
            boolean bl = index.processAllKeys(processor2, scope, idFilter);
            return bl;
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        finally {
            this.myAccessValidator.stoppedProcessingActivityForIndex((ID<?, ?>)indexKey);
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        final TIntArrayList result = new TIntArrayList();
        this.doProcessStubs(indexKey, dataKey, project2, scope, new StubIdListContainerAction(null, project2){

            @Override
            protected boolean process(int id, StubIdList value) {
                result.add(id);
                return true;
            }
        });
        return new IdIterator(){
            int cursor = 0;

            public boolean hasNext() {
                return this.cursor < result.size();
            }

            public int next() {
                return result.get(this.cursor++);
            }

            public int size() {
                return result.size();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return "Stub.IndexManager";
    }

    public void initComponent() {
        try {
            boolean forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
            StubIndexExtension[] extensions = (StubIndexExtension[])Extensions.getExtensions((ExtensionPointName)StubIndexExtension.EP_NAME);
            StringBuilder updated = new StringBuilder();
            for (StubIndexExtension extension : extensions) {
                boolean rebuildRequested = this.registerIndexer(extension, forceClean);
                if (!rebuildRequested) continue;
                updated.append(extension).append(' ');
            }
            if (updated.length() > 0) {
                final Throwable e = new Throwable(updated.toString());
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StubIndexImpl.this.forceRebuild(e);
                    }
                }, ModalityState.NON_MODAL);
            }
            this.dropUnregisteredIndices();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void disposeComponent() {
    }

    public void dispose() {
        for (UpdatableIndex updatableIndex : this.myIndices.values()) {
            updatableIndex.dispose();
        }
    }

    public void setDataBufferingEnabled(boolean enabled) {
        for (UpdatableIndex updatableIndex : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)updatableIndex).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMemoryStorage() {
        for (UpdatableIndex updatableIndex : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)updatableIndex).getStorage();
            updatableIndex.getWriteLock().lock();
            try {
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
            finally {
                updatableIndex.getWriteLock().unlock();
            }
        }
    }

    public void clearAllIndices() {
        for (UpdatableIndex updatableIndex : this.myIndices.values()) {
            try {
                updatableIndex.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void dropUnregisteredIndices() {
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (ID iD : this.myIndices.keySet()) {
            indicesToDrop.remove(iD.toString());
        }
        for (String string : indicesToDrop) {
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(ID.create((String)string)));
        }
    }

    @NotNull
    public StubIndexState getState() {
        return new StubIndexState(this.myIndices.keySet());
    }

    public void loadState(StubIndexState state) {
        this.myPreviouslyRegistered = state;
    }

    public final Lock getWriteLock(StubIndexKey indexKey) {
        return this.myIndices.get(indexKey).getWriteLock();
    }

    public Collection<StubIndexKey> getAllStubIndexKeys() {
        return Collections.unmodifiableCollection(this.myIndices.keySet());
    }

    public void flush(StubIndexKey key) throws StorageException {
        MyIndex<?> index = this.myIndices.get(key);
        index.flush();
    }

    public <K> void updateIndex(@NotNull StubIndexKey key, int fileId, final @NotNull Map<K, StubIdList> oldValues, final @NotNull Map<K, StubIdList> newValues) {
        try {
            UpdateData updateData;
            MyIndex<?> index = this.myIndices.get(key);
            if (MapDiffUpdateData.ourDiffUpdateEnabled) {
                updateData = new MapDiffUpdateData<K, StubIdList>((ID)key){

                    @Override
                    public void save(int inputId) throws IOException {
                    }

                    @Override
                    protected Map<K, StubIdList> getNewValue() {
                        return newValues;
                    }

                    @Override
                    protected Map<K, StubIdList> getCurrentValue() throws IOException {
                        return oldValues;
                    }
                };
            } else {
                MyIndex<?> myIndex = index;
                myIndex.getClass();
                updateData = new MapReduceIndex.SimpleUpdateData(myIndex, key, fileId, newValues, new NotNullComputable<Collection<K>>(){

                    @NotNull
                    public Collection<K> compute() {
                        return oldValues.keySet();
                    }
                });
            }
            index.updateWithMap(fileId, updateData);
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    protected <Psi extends PsiElement> void reportStubPsiMismatch(Psi psi, VirtualFile file2, Class<Psi> requiredClass) {
        FileElement treeElement;
        PsiFile psiFile;
        if (file2 == null) {
            super.reportStubPsiMismatch(psi, file2, requiredClass);
            return;
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.print("Invalid stub element type in index:");
        out.printf("\nfile: %s\npsiElement: %s\nrequiredClass: %s\nactualClass: %s", file2, psi, requiredClass, psi.getClass());
        FileType fileType = file2.getFileType();
        Language language = fileType instanceof LanguageFileType ? LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file2, psi.getProject()) : Language.ANY;
        out.printf("\nvirtualFile: size:%s; stamp:%s; modCount:%s; fileType:%s; language:%s", file2.getLength(), file2.getModificationStamp(), file2.getModificationCount(), fileType.getName(), language.getID());
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document != null) {
            boolean committed = PsiDocumentManager.getInstance((Project)psi.getProject()).isCommitted(document);
            boolean saved = !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            out.printf("\ndocument: size:%s; stamp:%s; committed:%s; saved:%s", document.getTextLength(), document.getModificationStamp(), committed, saved);
        }
        if ((psiFile = psi.getManager().findFile(file2)) != null) {
            out.printf("\npsiFile: size:%s; stamp:%s; class:%s; language:%s", psiFile.getTextLength(), psiFile.getViewProvider().getModificationStamp(), psiFile.getClass().getName(), psiFile.getLanguage().getID());
        }
        StubTree stub = psiFile instanceof PsiFileWithStubSupport ? ((PsiFileWithStubSupport)psiFile).getStubTree() : null;
        FileElement fileElement = treeElement = stub == null && psiFile instanceof PsiFileImpl ? ((PsiFileImpl)psiFile).getTreeElement() : null;
        if (stub != null) {
            out.printf("\nstubInfo: " + stub.getDebugInfo(), new Object[0]);
        } else if (treeElement != null) {
            out.printf("\nfileAST: size:%s; parsed:%s", treeElement.getTextLength(), treeElement.isParsed());
        }
        out.printf("\nindexing info: " + StubUpdatingIndex.getIndexingStampInfo(file2), new Object[0]);
        LOG.error(writer.toString());
    }

    private abstract class StubIdListContainerAction
    implements ValueContainer.ContainerAction<StubIdList> {
        private final IdFilter myIdFilter;

        StubIdListContainerAction(@NotNull IdFilter idFilter, Project project2) {
            this.myIdFilter = idFilter != null ? idFilter : ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project2);
        }

        @Override
        public boolean perform(int id, @NotNull StubIdList value) {
            ProgressManager.checkCanceled();
            if (this.myIdFilter != null && !this.myIdFilter.containsFileId(id)) {
                return true;
            }
            return this.process(id, value);
        }

        protected abstract boolean process(int var1, StubIdList var2);
    }

    private static class MyIndex<K>
    extends MapReduceIndex<K, StubIdList, Void> {
        public MyIndex(IndexStorage<K, StubIdList> storage2) throws IOException {
            super(null, null, storage2);
        }

        @Override
        public void updateWithMap(int inputId, @NotNull UpdateData<K, StubIdList> updateData) throws StorageException {
            super.updateWithMap(inputId, updateData);
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        private StubIdExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull StubIdList value) throws IOException {
            int size = value.size();
            if (size == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            int size = DataInputOutputUtil.readINT((DataInput)in);
            if (size == Integer.MAX_VALUE) {
                return new StubIdList();
            }
            if (size >= 0) {
                return new StubIdList(size);
            }
            size = -size;
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                result[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            return new StubIdList(result, size);
        }
    }
}

