/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubSerializationHelper;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class SerializationManagerImpl
extends SerializationManagerEx
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.SerializationManagerImpl");
    private final AtomicBoolean myNameStorageCrashed = new AtomicBoolean(false);
    private final File myFile = new File(PathManager.getIndexRoot(), "rep.names");
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private AbstractStringEnumerator myNameStorage;
    private StubSerializationHelper myStubSerializationHelper;

    public SerializationManagerImpl() {
        this.myFile.getParentFile().mkdirs();
        try {
            this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
            this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage);
            this.registerSerializer((ObjectStubSerializer)PsiFileStubImpl.TYPE);
        }
        catch (IOException e) {
            try {
                this.nameStorageCrashed();
                LOG.info((Throwable)e);
                this.repairNameStorage();
                this.nameStorageCrashed();
                this.registerSerializer((ObjectStubSerializer)PsiFileStubImpl.TYPE);
            }
            catch (Throwable throwable) {
                this.registerSerializer((ObjectStubSerializer)PsiFileStubImpl.TYPE);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        SerializationManagerImpl.this.performShutdown();
                    }
                });
                throw throwable;
            }
            ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
        }
        ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
    }

    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                LOG.info("Name storage is repaired");
                if (this.myNameStorage != null) {
                    this.myNameStorage.close();
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
                this.myNameStorage = new PersistentStringEnumerator(this.myFile, true);
                this.myStubSerializationHelper = new StubSerializationHelper(this.myNameStorage);
                for (ObjectStubSerializer serializer : this.myAllSerializers) {
                    this.myStubSerializationHelper.assignId(serializer);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.nameStorageCrashed();
            }
        }
    }

    public void flushNameStorage() {
        if (this.myNameStorage.isDirty()) {
            this.myNameStorage.force();
        }
    }

    public String internString(String string) {
        return this.myStubSerializationHelper.intern(string);
    }

    public void reinitializeNameStorage() {
        this.nameStorageCrashed();
        this.repairNameStorage();
    }

    protected void nameStorageCrashed() {
        this.myNameStorageCrashed.set(true);
    }

    @NotNull
    public String getComponentName() {
        return "PSI.SerializationManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        LOG.info("START StubSerializationManager SHUTDOWN");
        try {
            this.myNameStorage.close();
            LOG.info("END StubSerializationManager SHUTDOWN");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void registerSerializer(@NotNull ObjectStubSerializer serializer) {
        super.registerSerializer(serializer);
        try {
            this.myStubSerializationHelper.assignId(serializer);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    public void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) {
        this.initSerializers();
        try {
            this.myStubSerializationHelper.serialize(rootStub, stream);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.nameStorageCrashed();
        }
    }

    @NotNull
    public Stub deserialize(@NotNull InputStream stream) throws SerializerNotFoundException {
        this.initSerializers();
        try {
            return this.myStubSerializationHelper.deserialize(stream);
        }
        catch (IOException e) {
            this.nameStorageCrashed();
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

