/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

class StatisticsUnit {
    private static final int FORMAT_VERSION_NUMBER = 5;
    private final int myNumber;
    private final THashMap<String, LinkedList<String>> myDataMap = new THashMap();

    public StatisticsUnit(int number) {
        this.myNumber = number;
    }

    public int getRecency(String key1, String key2) {
        List list = (List)this.myDataMap.get((Object)key1);
        if (list == null) {
            return Integer.MAX_VALUE;
        }
        int i = list.indexOf(key2);
        return i >= 0 ? i : Integer.MAX_VALUE;
    }

    public int getData(String key1, String key2) {
        List list = (List)this.myDataMap.get((Object)key1);
        if (list == null) {
            return 0;
        }
        int result = 0;
        for (String s : list) {
            if (!s.equals(key2)) continue;
            ++result;
        }
        return result;
    }

    public void incData(String key1, String key2) {
        LinkedList<String> list = (LinkedList<String>)this.myDataMap.get((Object)key1);
        if (list == null) {
            list = new LinkedList<String>();
            this.myDataMap.put((Object)key1, list);
        }
        list.addFirst(key2);
        if (list.size() > 7) {
            list.removeLast();
        }
    }

    public String[] getKeys2(String key1) {
        List list = (List)this.myDataMap.get((Object)key1);
        if (list == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return ArrayUtil.toStringArray(new LinkedHashSet(list));
    }

    public int getNumber() {
        return this.myNumber;
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeInt(5);
        dataOut.writeInt(this.myDataMap.size());
        for (String context : this.myDataMap.keySet()) {
            List list = (List)this.myDataMap.get((Object)context);
            if (list == null || list.isEmpty()) continue;
            dataOut.writeUTF(context);
            dataOut.writeInt(list.size());
            for (String data : list) {
                dataOut.writeUTF(data);
            }
        }
    }

    public void read(InputStream in) throws IOException, WrongFormatException {
        DataInputStream dataIn = new DataInputStream(in);
        int formatVersion = dataIn.readInt();
        if (formatVersion != 5) {
            throw new WrongFormatException();
        }
        this.myDataMap.clear();
        int size = dataIn.readInt();
        for (int i = 0; i < size; ++i) {
            String context = dataIn.readUTF();
            int len = dataIn.readInt();
            LinkedList<String> list = new LinkedList<String>();
            for (int j = 0; j < len; ++j) {
                list.add(dataIn.readUTF());
            }
            this.myDataMap.put((Object)context, list);
        }
    }
}

