/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScopeEnlarger;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeBuilderImpl
extends ProjectScopeBuilder {
    protected final Project myProject;

    public ProjectScopeBuilderImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        ProjectAndLibrariesScope result = new ProjectAndLibrariesScope(this.myProject){

            public boolean contains(@NotNull VirtualFile file2) {
                return this.myProjectFileIndex.isInLibrarySource(file2) || this.myProjectFileIndex.isInLibraryClasses(file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return false;
            }
        };
        result.setDisplayName(PsiBundle.message((String)"psi.search.scope.libraries", (Object[])new Object[0]));
        return result;
    }

    @NotNull
    public GlobalSearchScope buildAllScope() {
        SearchScopeEnlarger each;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            return new EverythingGlobalScope(this.myProject);
        }
        boolean searchOutsideRootModel = false;
        SearchScopeEnlarger[] searchScopeEnlargerArray = (SearchScopeEnlarger[])Extensions.getExtensions(SearchScopeEnlarger.EXTENSION);
        int n = searchScopeEnlargerArray.length;
        for (int i = 0; i < n && !(searchOutsideRootModel = (each = searchScopeEnlargerArray[i]).allScopeSearchesOutsideRootModel(this.myProject)); ++i) {
        }
        return new ProjectAndLibrariesScope(this.myProject, searchOutsideRootModel);
    }

    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            return new EverythingGlobalScope(this.myProject){

                public boolean isSearchInLibraries() {
                    return false;
                }
            };
        }
        return new ProjectScopeImpl(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }

    @NotNull
    public GlobalSearchScope buildContentScope() {
        return new CoreProjectScopeBuilder.ContentSearchScope(this.myProject, FileIndexFacade.getInstance((Project)this.myProject));
    }
}

