/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public boolean indexDirectories() {
        return true;
    }

    public int getVersion() {
        return 1 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 1 : 0);
    }

    public static String[] getAllFilenames(Project project2) {
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(NAME, project2);
        return ArrayUtil.toStringArray((Collection)allKeys);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, scope);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project2, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project2, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, null);
    }

    public static PsiFile[] getFilesByName(Project project2, String name, GlobalSearchScope scope) {
        return (PsiFile[])FilenameIndex.getFilesByName(project2, name, scope, false);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        return FilenameIndex.processFilesByName(name, includeDirs, true, processor2, scope, project2, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean includeDirs, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project2, @Nullable IdFilter idFilter) {
        Object files;
        if (caseSensitively) {
            files = new THashSet();
            FileBasedIndex.getInstance().processValues(NAME, (Object)name, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>((Set)files){
                final /* synthetic */ Set val$files;
                {
                    this.val$files = set;
                }

                public boolean process(VirtualFile file2, Void value) {
                    this.val$files.add(file2);
                    return true;
                }
            }, scope, idFilter);
        } else {
            files = FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, idFilter);
        }
        if (files.isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        int processedFiles = 0;
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            PsiDirectory dir;
            VirtualFile file2 = (VirtualFile)iterator.next();
            if (!file2.isValid()) continue;
            if (!includeDirs && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!includeDirs || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(final @NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        THashSet keys = new THashSet();
        FileBasedIndex index = FileBasedIndex.getInstance();
        index.processAllKeys(NAME, (Processor)new Processor<String>((Set)keys){
            final /* synthetic */ Set val$keys;
            {
                this.val$keys = set;
            }

            public boolean process(String value) {
                if (name.equalsIgnoreCase(value)) {
                    this.val$keys.add(value);
                }
                return true;
            }
        }, scope, idFilter);
        THashSet files = new THashSet();
        for (String each : keys) {
            files.addAll(index.getContainingFiles(NAME, (Object)each, scope));
        }
        return files;
    }

    public static PsiFileSystemItem[] getFilesByName(Project project2, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        SmartList result = new SmartList();
        FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)new CommonProcessors.CollectProcessor((Collection)result), scope, project2, null);
        if (includeDirs) {
            return (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result, PsiFileSystemItem.class);
        }
        return (PsiFileSystemItem[])result.toArray((Object[])new PsiFile[result.size()]);
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext) {
        return FilenameIndex.getAllFilesByExt(project2, ext, GlobalSearchScope.allScope((Project)project2));
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project2, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len = ext.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project2)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files.addAll(FilenameIndex.getVirtualFilesByName(project2, name, searchScope));
        }
        return files;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        public boolean acceptInput(@NotNull VirtualFile file2) {
            return true;
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            return Collections.singletonMap(inputData.getFileName(), null);
        }
    }
}

