/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    protected boolean myHasAccessibleStaticCorrectCandidate = false;

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container) {
        super(resolvers, container, place, placeFile);
    }

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile) {
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, (List<CandidateInfo>)new SmartList(), place, placeFile);
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            this.addMethod(method, substitutor, this.isInStaticScope() && !method.hasModifierProperty("static"));
        }
    }

    public void addMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem) {
        boolean isAccessible;
        boolean bl = isAccessible = JavaResolveUtil.isAccessible((PsiMember)method, this.getContainingClass(method), method.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext, this.myPlaceFile) && !this.isShadowed(method);
        if (!(!this.isAccepted(method) || this.isInterfaceStaticMethodAccessibleThroughInheritance(method) && ImportsUtil.hasStaticImportOn((PsiElement)this.myPlace, (PsiMember)method, (boolean)true))) {
            PsiClass containingClass;
            if (!staticProblem && this.myAccessClass != null && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !(this.myAccessClass instanceof PsiTypeParameter) && !containingClass.equals(this.myAccessClass)) {
                staticProblem = true;
            }
            this.add((CandidateInfo)this.createCandidateInfo(method, substitutor, staticProblem, isAccessible, false));
            if (this.acceptVarargs() && method.isVarArgs() && PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myPlace)) {
                this.add((CandidateInfo)this.createCandidateInfo(method, substitutor, staticProblem, isAccessible, true));
            }
            this.myHasAccessibleStaticCorrectCandidate |= isAccessible && !staticProblem;
        }
    }

    private boolean isInterfaceStaticMethodAccessibleThroughInheritance(PsiMethod method) {
        if (method.hasModifierProperty("static") && !(this.myCurrentFileContext instanceof PsiImportStaticStatement) && this.myPlace instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)this.myPlace).getMethodExpression().getQualifierExpression() == null) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface();
        }
        return false;
    }

    protected PsiClass getContainingClass(PsiMethod method) {
        return method.getContainingClass();
    }

    protected boolean acceptVarargs() {
        return false;
    }

    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, final boolean varargs) {
        final PsiExpressionList argumentList = this.getArgumentList();
        return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, (PsiElement)argumentList, this.myCurrentFileContext, null, this.getTypeArguments(), this.getLanguageLevel()){
            private PsiType[] myExpressionTypes;

            public PsiType[] getArgumentTypes() {
                if (this.myExpressionTypes == null && argumentList != null) {
                    PsiType[] expressionTypes = MethodCandidatesProcessor.getExpressionTypes(argumentList);
                    if (MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck()) {
                        return expressionTypes;
                    }
                    this.myExpressionTypes = expressionTypes;
                }
                return this.myExpressionTypes;
            }

            public boolean isVarargs() {
                return varargs;
            }
        };
    }

    protected static PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
        return argumentList != null ? argumentList.getExpressionTypes() : null;
    }

    protected boolean isAccepted(PsiMethod candidate) {
        if (!this.isConstructor()) {
            return !candidate.isConstructor() && candidate.getName().equals(this.getName(ResolveState.initial()));
        }
        if (!candidate.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            PsiClass containingClass = this.getContainingClass(candidate);
            return containingClass != null && containingClass.equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.isEquivalentTo((PsiElement)this.getContainingClass(candidate));
    }

    protected boolean isShadowed(PsiMethod candidate) {
        if (this.myCurrentFileContext instanceof PsiImportStaticStatement) {
            for (JavaResolveResult result : this.getResults()) {
                if (result.getElement() == candidate || !result.isAccessible() || result.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateInfo[] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        if (resolveResult.length == 0) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] infos = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos, 0, resolveResult.length);
        return infos;
    }
}

