/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPresentationUtil {
    private JavaPresentationUtil() {
    }

    @NotNull
    public static ColoredItemPresentation getMethodPresentation(final @NotNull PsiMethod psiMethod) {
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiMethod.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText((PsiElement)psiMethod);
            }

            public Icon getIcon(boolean open2) {
                return psiMethod.getIcon(1);
            }
        };
    }

    @NotNull
    public static ItemPresentation getFieldPresentation(final @NotNull PsiField psiField) {
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return psiField.getName();
            }

            public TextAttributesKey getTextAttributesKey() {
                if (psiField.isDeprecated()) {
                    return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText((PsiElement)psiField);
            }

            public Icon getIcon(boolean open2) {
                return psiField.getIcon(1);
            }
        };
    }

    @Nullable
    private static String getJavaSymbolContainerText(@NotNull PsiElement element) {
        String qName;
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        String result = container instanceof PsiClass ? ((qName = ((PsiClass)container).getQualifiedName()) != null ? qName : ((PsiClass)container).getName()) : (container instanceof PsiJavaFile ? ((PsiJavaFile)container).getPackageName() : null);
        if (result != null) {
            return PsiBundle.message((String)"aux.context.display", (Object[])new Object[]{result});
        }
        return null;
    }
}

