/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiWhileStatementImpl
extends CompositePsiElement
implements PsiWhileStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiWhileStatementImpl");

    public PsiWhileStatementImpl() {
        super(WHILE_STATEMENT);
    }

    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 35: {
                return this.findChildByType(WHILE_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        return PsiImplUtil.findStatementChild(this);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == WHILE_KEYWORD) {
            return 35;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitWhileStatement((PsiWhileStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiWhileStatement";
    }
}

