/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;

public class PsiTypeParameterListImpl
extends JavaStubPsiElement<PsiTypeParameterListStub>
implements PsiTypeParameterList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiTypeParameterListImpl");

    public PsiTypeParameterListImpl(PsiTypeParameterListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public PsiTypeParameterListImpl(ASTNode node) {
        super(node);
    }

    public PsiTypeParameter[] getTypeParameters() {
        return (PsiTypeParameter[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER, PsiTypeParameter.ARRAY_FACTORY);
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        LOG.assertTrue(typeParameter.getParent() == this);
        return PsiImplUtil.getTypeParameterIndex(typeParameter, this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiTypeParameter[] parameters;
        for (PsiTypeParameter parameter : parameters = this.getTypeParameters()) {
            if (processor2.execute((PsiElement)parameter, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeParameterList((PsiTypeParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiTypeParameterList";
    }
}

