/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends ExpressionPsiElement
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
ContributedReferenceHost {
    @NonNls
    private static final String QUOT = "&quot;";
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);
    public static final TokenSet INTEGER_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL});
    public static final TokenSet REAL_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL});
    public static final TokenSet NUMERIC_LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{INTEGER_LITERALS, REAL_LITERALS});

    public PsiLiteralExpressionImpl() {
        super(JavaElementType.LITERAL_EXPRESSION);
    }

    public PsiType getType() {
        IElementType type = this.getLiteralElementType();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (type == JavaTokenType.STRING_LITERAL) {
            PsiManager manager = this.getManager();
            GlobalSearchScope resolveScope = ResolveScopeManager.getElementResolveScope(this);
            return PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)resolveScope);
        }
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public IElementType getLiteralElementType() {
        return this.getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        TreeElement literal = this.getFirstChildNode();
        IElementType type = literal.getElementType();
        return NUMERIC_LITERALS.contains(type) ? LiteralFormatUtil.removeUnderscores(literal.getText()) : literal.getText();
    }

    public Object getValue() {
        IElementType type = this.getLiteralElementType();
        String text = NUMERIC_LITERALS.contains(type) ? this.getCanonicalText().toLowerCase(Locale.ENGLISH) : this.getCanonicalText();
        int textLength = text.length();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            try {
                if (text.startsWith(HEX_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 32);
                    return (int)value;
                }
                if (text.startsWith(BIN_PREFIX)) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text.substring(2), 1, 32);
                    return (int)value;
                }
                if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                    long value = PsiLiteralExpressionImpl.parseDigits(text, 3, 32);
                    return (int)value;
                }
                long l = Long.parseLong(text, 10);
                if (text.equals(_2_IN_31)) {
                    return (int)l;
                }
                long converted = (int)l;
                return l == converted ? Integer.valueOf((int)l) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text, (char)'L') || StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
                text = text.substring(0, textLength - 1);
            }
            try {
                if (text.startsWith(HEX_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text.substring(2), 4, 64);
                }
                if (text.startsWith(BIN_PREFIX)) {
                    return PsiLiteralExpressionImpl.parseDigits(text.substring(2), 1, 64);
                }
                if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                    return PsiLiteralExpressionImpl.parseDigits(text, 3, 64);
                }
                if (_2_IN_63.equals(text)) {
                    return Long.MIN_VALUE;
                }
                return Long.valueOf(text, 10);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            if (StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                if (textLength == 1) {
                    return null;
                }
                text = text.substring(1, textLength - 1);
            } else {
                text = text.substring(1, textLength);
            }
            StringBuilder chars = new StringBuilder();
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text, chars, null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        if (type == JavaTokenType.STRING_LITERAL) {
            String innerText = this.getInnerText();
            return innerText == null ? null : PsiLiteralExpressionImpl.internedParseStringCharacters(innerText);
        }
        if (type == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Nullable
    public String getInnerText() {
        String text = this.getCanonicalText();
        int textLength = text.length();
        if (StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
            if (textLength == 1) {
                return null;
            }
            text = text.substring(1, textLength - 1);
        } else if (text.startsWith(QUOT) && text.endsWith(QUOT) && textLength > QUOT.length()) {
            text = text.substring(QUOT.length(), textLength - QUOT.length());
        } else {
            return null;
        }
        return text;
    }

    private static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLiteralExpression((PsiLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    public boolean isValidHost() {
        return this.getValue() instanceof String;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        IElementType type = this.getLiteralElementType();
        if (type != JavaTokenType.STRING_LITERAL && type != JavaTokenType.INTEGER_LITERAL) {
            return PsiReference.EMPTY_ARRAY;
        }
        return PsiReferenceService.getService().getContributedReferences((PsiElement)this);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        TreeElement valueNode = this.getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
    }
}

