/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PsiDeclarationStatementImpl
extends CompositePsiElement
implements PsiDeclarationStatement {
    private static final TokenSet DECLARED_ELEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LOCAL_VARIABLE, JavaElementType.CLASS});

    public PsiDeclarationStatementImpl() {
        super(JavaElementType.DECLARATION_STATEMENT);
    }

    @NotNull
    public PsiElement[] getDeclaredElements() {
        return this.getChildrenAsPsiElements(DECLARED_ELEMENT_BIT_SET, PsiElement.ARRAY_FACTORY);
    }

    @Override
    public int getChildRole(ASTNode child) {
        if (child.getElementType() == JavaTokenType.COMMA) {
            return 23;
        }
        return super.getChildRole(child);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement[] declaredElements;
        int length;
        if (DECLARED_ELEMENT_BIT_SET.contains(child.getElementType()) && (length = (declaredElements = this.getDeclaredElements()).length) > 0) {
            if (length == 1) {
                this.getTreeParent().deleteChildInternal(this);
                return;
            }
            if (SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 1]) == child) {
                this.removeCommaBefore(child);
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, SharedImplUtil.findCharTableByTree(this), this.getManager());
                SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 2]).addChild((ASTNode)semicolon, null);
            } else if (SourceTreeToPsiMap.psiElementToTree(declaredElements[0]) == child) {
                CompositeElement next = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(declaredElements[1]);
                ASTNode copyChild = child.copyElement();
                ASTNode nameChild = ((CompositeElement)copyChild).findChildByRole(9);
                this.removeCommaBefore(next);
                next.addInternal((TreeElement)copyChild.getFirstChildNode(), nameChild.getTreePrev(), null, Boolean.FALSE);
            } else {
                this.removeCommaBefore(child);
            }
        }
        super.deleteChildInternal(child);
    }

    private void removeCommaBefore(ASTNode child) {
        ASTNode prev = child;
        while ((prev = prev.getTreePrev()) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(prev.getElementType())) {
        }
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            this.deleteChildInternal(prev);
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDeclarationStatement((PsiDeclarationStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiDeclarationStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiElement[] decls;
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (PsiElement decl : decls = this.getDeclaredElements()) {
            if (decl != lastParent) {
                if (processor2.execute(decl, state)) continue;
                return false;
            }
            ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
            if (!(lastParent instanceof PsiClass) || hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || processor2.execute(lastParent, state)) continue;
            return false;
        }
        return true;
    }
}

