/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiCompositeModifierList
extends LightModifierList {
    private final List<PsiModifierList> mySublists;

    public PsiCompositeModifierList(PsiManager manager, List<PsiModifierList> sublists) {
        super(manager);
        this.mySublists = sublists;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        ArrayList annotations = new ArrayList();
        for (PsiModifierList list : this.mySublists) {
            ContainerUtil.addAll(annotations, (Object[])list.getAnnotations());
        }
        return annotations.toArray(new PsiAnnotation[annotations.size()]);
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        for (PsiModifierList sublist : this.mySublists) {
            PsiAnnotation annotation = sublist.findAnnotation(qualifiedName);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasModifierProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasExplicitModifier(name)) continue;
            return true;
        }
        return false;
    }
}

