/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiCatchSectionImpl");
    private final Object myTypesCacheLock = new Object();
    private CachedValue<List<PsiType>> myTypesCache = null;

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    public PsiType getCatchType() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.getType();
    }

    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return Collections.emptyList();
        }
        return (List)this.getTypesCache().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            this.myTypesCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedValue<List<PsiType>> getTypesCache() {
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            if (this.myTypesCache == null) {
                CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)this.getProject());
                this.myTypesCache = cacheManager.createCachedValue((CachedValueProvider)new CachedValueProvider<List<PsiType>>(){

                    public CachedValueProvider.Result<List<PsiType>> compute() {
                        List types = PsiCatchSectionImpl.this.computePreciseCatchTypes(PsiCatchSectionImpl.this.getParameter());
                        return CachedValueProvider.Result.create((Object)types, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                }, false);
            }
            return this.myTypesCache;
        }
    }

    private List<PsiType> computePreciseCatchTypes(final @Nullable PsiParameter parameter) {
        if (parameter == null) {
            return ContainerUtil.emptyList();
        }
        PsiType declaredType = parameter.getType();
        if (PsiUtil.getLanguageLevel((PsiElement)parameter).isAtLeast(LanguageLevel.JDK_1_7) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter, this.getCatchBlock())) {
            PsiTryStatement statement2 = this.getTryStatement();
            Collection<PsiClassType> thrownTypes = PsiCatchSectionImpl.getThrownTypes(statement2);
            if (thrownTypes.isEmpty()) {
                return Collections.emptyList();
            }
            final PsiParameter[] parameters = statement2.getCatchBlockParameters();
            List uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, (Function)new NullableFunction<PsiClassType, PsiType>(){

                public PsiType fun(PsiClassType thrownType) {
                    for (int i = 0; i < parameters.length && parameters[i] != parameter; ++i) {
                        PsiType catchType = parameters[i].getType();
                        if (!catchType.isAssignableFrom((PsiType)thrownType)) continue;
                        return null;
                    }
                    return thrownType;
                }
            });
            boolean passed = true;
            for (PsiType type : uncaughtTypes) {
                if (declaredType.isAssignableFrom(type)) continue;
                passed = false;
                break;
            }
            if (passed) {
                return uncaughtTypes;
            }
        }
        return Collections.singletonList(declaredType);
    }

    private static Collection<PsiClassType> getThrownTypes(@NotNull PsiTryStatement statement2) {
        PsiResourceList resourceList;
        ArrayList types = ContainerUtil.newArrayList();
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        if (tryBlock != null) {
            types.addAll(ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            types.addAll(ExceptionUtil.getThrownExceptions((PsiElement)resourceList));
        }
        return types;
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter, @Nullable PsiCodeBlock catchBlock) {
        final boolean[] result = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    if (expression.resolve() == parameter && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                        result[0] = false;
                        this.stopWalking();
                    }
                }
            });
        }
        return result[0];
    }

    @NotNull
    public PsiTryStatement getTryStatement() {
        return (PsiTryStatement)this.getParent();
    }

    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRole(50);
    }

    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRole(51);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitCatchSection((PsiCatchSection)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiCatchSection";
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                return null;
            }
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: 
        }
        return this.findChildByType((IElementType)CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor2.execute((PsiElement)catchParameter, state);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor2, state, lastParent, place);
    }
}

