/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import org.jetbrains.annotations.NotNull;

public class XmlTextLiteralEscaper
extends LiteralTextEscaper<XmlTextImpl> {
    public XmlTextLiteralEscaper(XmlTextImpl xmlText) {
        super((PsiLanguageInjectionHost)xmlText);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        int startInDecoded = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHost.getStartOffset());
        int endInDecoded = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHost.getEndOffset());
        outChars.append(((XmlTextImpl)this.myHost).getValue(), startInDecoded, endInDecoded);
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int rangeInsideHostEndOffset;
        int rangeInsideHostStartOffset = rangeInsideHost.getStartOffset();
        int displayStart = ((XmlTextImpl)this.myHost).physicalToDisplay(rangeInsideHostStartOffset);
        int i = ((XmlTextImpl)this.myHost).displayToPhysical(offsetInDecoded + displayStart);
        if (i < rangeInsideHostStartOffset) {
            i = rangeInsideHostStartOffset;
        }
        if (i > (rangeInsideHostEndOffset = rangeInsideHost.getEndOffset())) {
            i = rangeInsideHostEndOffset;
        }
        return i;
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        return ((XmlTextImpl)this.myHost).getCDATAInterior();
    }

    public boolean isOneLine() {
        return false;
    }
}

