/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedPsiCachedValueProvider
implements ParameterizedCachedValueProvider<MultiHostRegistrarImpl, PsiElement> {
    InjectedPsiCachedValueProvider() {
    }

    public CachedValueProvider.Result<MultiHostRegistrarImpl> compute(PsiElement element) {
        PsiFile hostPsiFile = element.getContainingFile();
        if (hostPsiFile == null) {
            return null;
        }
        FileViewProvider viewProvider = hostPsiFile.getViewProvider();
        DocumentEx hostDocument = (DocumentEx)viewProvider.getDocument();
        if (hostDocument == null) {
            return null;
        }
        PsiManager psiManager = viewProvider.getManager();
        Project project2 = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project2);
        MultiHostRegistrarImpl result = InjectedPsiCachedValueProvider.doCompute(element, injectedManager, project2, hostPsiFile);
        return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, hostDocument});
    }

    @Nullable
    static MultiHostRegistrarImpl doCompute(@NotNull PsiElement element, @NotNull InjectedLanguageManagerImpl injectedManager, Project project2, PsiFile hostPsiFile) {
        MyInjProcessor processor2 = new MyInjProcessor(project2, hostPsiFile);
        injectedManager.processInPlaceInjectorsFor(element, processor2);
        MultiHostRegistrarImpl registrar = processor2.hostRegistrar;
        return registrar == null || registrar.getResult() == null ? null : registrar;
    }

    private static class MyInjProcessor
    implements InjectedLanguageManagerImpl.InjProcessor {
        private MultiHostRegistrarImpl hostRegistrar;
        private final Project myProject;
        private final PsiFile myHostPsiFile;

        private MyInjProcessor(Project project2, PsiFile hostPsiFile) {
            this.myProject = project2;
            this.myHostPsiFile = hostPsiFile;
        }

        @Override
        public boolean process(PsiElement element, MultiHostInjector injector) {
            if (this.hostRegistrar == null) {
                this.hostRegistrar = new MultiHostRegistrarImpl(this.myProject, this.myHostPsiFile, element);
            }
            injector.getLanguagesToInject((MultiHostRegistrar)this.hostRegistrar, element);
            List<Pair<Place, PsiFile>> result = this.hostRegistrar.getResult();
            return result == null;
        }
    }
}

